package xtrace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTraceAnalysis invokes the xtrace.GetTraceAnalysis API synchronously
func (client *Client) GetTraceAnalysis(request *GetTraceAnalysisRequest) (response *GetTraceAnalysisResponse, err error) {
	response = CreateGetTraceAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// GetTraceAnalysisWithChan invokes the xtrace.GetTraceAnalysis API asynchronously
func (client *Client) GetTraceAnalysisWithChan(request *GetTraceAnalysisRequest) (<-chan *GetTraceAnalysisResponse, <-chan error) {
	responseChan := make(chan *GetTraceAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTraceAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTraceAnalysisWithCallback invokes the xtrace.GetTraceAnalysis API asynchronously
func (client *Client) GetTraceAnalysisWithCallback(request *GetTraceAnalysisRequest, callback func(response *GetTraceAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTraceAnalysisResponse
		var err error
		defer close(result)
		response, err = client.GetTraceAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTraceAnalysisRequest is the request struct for api GetTraceAnalysis
type GetTraceAnalysisRequest struct {
	*requests.RpcRequest
	Query       string `position:"Query" name:"Query"`
	Api         string `position:"Query" name:"Api"`
	ProxyUserId string `position:"Query" name:"ProxyUserId"`
}

// GetTraceAnalysisResponse is the response struct for api GetTraceAnalysis
type GetTraceAnalysisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetTraceAnalysisRequest creates a request to invoke GetTraceAnalysis API
func CreateGetTraceAnalysisRequest() (request *GetTraceAnalysisRequest) {
	request = &GetTraceAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("xtrace", "2019-08-08", "GetTraceAnalysis", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTraceAnalysisResponse creates a response to parse from GetTraceAnalysis response
func CreateGetTraceAnalysisResponse() (response *GetTraceAnalysisResponse) {
	response = &GetTraceAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
