package safconsole

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendFeedback invokes the safconsole.SendFeedback API synchronously
func (client *Client) SendFeedback(request *SendFeedbackRequest) (response *SendFeedbackResponse, err error) {
	response = CreateSendFeedbackResponse()
	err = client.DoAction(request, response)
	return
}

// SendFeedbackWithChan invokes the safconsole.SendFeedback API asynchronously
func (client *Client) SendFeedbackWithChan(request *SendFeedbackRequest) (<-chan *SendFeedbackResponse, <-chan error) {
	responseChan := make(chan *SendFeedbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendFeedback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendFeedbackWithCallback invokes the safconsole.SendFeedback API asynchronously
func (client *Client) SendFeedbackWithCallback(request *SendFeedbackRequest, callback func(response *SendFeedbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendFeedbackResponse
		var err error
		defer close(result)
		response, err = client.SendFeedback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendFeedbackRequest is the request struct for api SendFeedback
type SendFeedbackRequest struct {
	*requests.RpcRequest
	RiskLabel  string `position:"Query" name:"RiskLabel"`
	SampleType string `position:"Query" name:"SampleType"`
	Value      string `position:"Query" name:"Value"`
}

// SendFeedbackResponse is the response struct for api SendFeedback
type SendFeedbackResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendFeedbackRequest creates a request to invoke SendFeedback API
func CreateSendFeedbackRequest() (request *SendFeedbackRequest) {
	request = &SendFeedbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("safconsole", "2021-01-12", "SendFeedback", "saf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendFeedbackResponse creates a response to parse from SendFeedback response
func CreateSendFeedbackResponse() (response *SendFeedbackResponse) {
	response = &SendFeedbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
