package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppGroupDataReport invokes the opensearch.DescribeAppGroupDataReport API synchronously
func (client *Client) DescribeAppGroupDataReport(request *DescribeAppGroupDataReportRequest) (response *DescribeAppGroupDataReportResponse, err error) {
	response = CreateDescribeAppGroupDataReportResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppGroupDataReportWithChan invokes the opensearch.DescribeAppGroupDataReport API asynchronously
func (client *Client) DescribeAppGroupDataReportWithChan(request *DescribeAppGroupDataReportRequest) (<-chan *DescribeAppGroupDataReportResponse, <-chan error) {
	responseChan := make(chan *DescribeAppGroupDataReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppGroupDataReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppGroupDataReportWithCallback invokes the opensearch.DescribeAppGroupDataReport API asynchronously
func (client *Client) DescribeAppGroupDataReportWithCallback(request *DescribeAppGroupDataReportRequest, callback func(response *DescribeAppGroupDataReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppGroupDataReportResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppGroupDataReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppGroupDataReportRequest is the request struct for api DescribeAppGroupDataReport
type DescribeAppGroupDataReportRequest struct {
	*requests.RoaRequest
	EndTime          string `position:"Query" name:"endTime"`
	StartTime        string `position:"Query" name:"startTime"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// DescribeAppGroupDataReportResponse is the response struct for api DescribeAppGroupDataReport
type DescribeAppGroupDataReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeAppGroupDataReportRequest creates a request to invoke DescribeAppGroupDataReport API
func CreateDescribeAppGroupDataReportRequest() (request *DescribeAppGroupDataReportRequest) {
	request = &DescribeAppGroupDataReportRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeAppGroupDataReport", "/v4/openapi/app-groups/[appGroupIdentity]/data-report", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeAppGroupDataReportResponse creates a response to parse from DescribeAppGroupDataReport response
func CreateDescribeAppGroupDataReportResponse() (response *DescribeAppGroupDataReportResponse) {
	response = &DescribeAppGroupDataReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
