package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConnectableClusters invokes the elasticsearch.DescribeConnectableClusters API synchronously
func (client *Client) DescribeConnectableClusters(request *DescribeConnectableClustersRequest) (response *DescribeConnectableClustersResponse, err error) {
	response = CreateDescribeConnectableClustersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConnectableClustersWithChan invokes the elasticsearch.DescribeConnectableClusters API asynchronously
func (client *Client) DescribeConnectableClustersWithChan(request *DescribeConnectableClustersRequest) (<-chan *DescribeConnectableClustersResponse, <-chan error) {
	responseChan := make(chan *DescribeConnectableClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConnectableClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConnectableClustersWithCallback invokes the elasticsearch.DescribeConnectableClusters API asynchronously
func (client *Client) DescribeConnectableClustersWithCallback(request *DescribeConnectableClustersRequest, callback func(response *DescribeConnectableClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConnectableClustersResponse
		var err error
		defer close(result)
		response, err = client.DescribeConnectableClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConnectableClustersRequest is the request struct for api DescribeConnectableClusters
type DescribeConnectableClustersRequest struct {
	*requests.RoaRequest
	InstanceId      string           `position:"Path" name:"InstanceId"`
	AlreadySetItems requests.Boolean `position:"Query" name:"alreadySetItems"`
}

// DescribeConnectableClustersResponse is the response struct for api DescribeConnectableClusters
type DescribeConnectableClustersResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Result    []ConnectableClustersInfo `json:"Result" xml:"Result"`
}

// CreateDescribeConnectableClustersRequest creates a request to invoke DescribeConnectableClusters API
func CreateDescribeConnectableClustersRequest() (request *DescribeConnectableClustersRequest) {
	request = &DescribeConnectableClustersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeConnectableClusters", "/openapi/instances/[InstanceId]/connectable-clusters", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeConnectableClustersResponse creates a response to parse from DescribeConnectableClusters response
func CreateDescribeConnectableClustersResponse() (response *DescribeConnectableClustersResponse) {
	response = &DescribeConnectableClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
