package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HeadquartersToolsO2O invokes the cloudwf.HeadquartersToolsO2O API synchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolso2o.html
func (client *Client) HeadquartersToolsO2O(request *HeadquartersToolsO2ORequest) (response *HeadquartersToolsO2OResponse, err error) {
	response = CreateHeadquartersToolsO2OResponse()
	err = client.DoAction(request, response)
	return
}

// HeadquartersToolsO2OWithChan invokes the cloudwf.HeadquartersToolsO2O API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolso2o.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersToolsO2OWithChan(request *HeadquartersToolsO2ORequest) (<-chan *HeadquartersToolsO2OResponse, <-chan error) {
	responseChan := make(chan *HeadquartersToolsO2OResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HeadquartersToolsO2O(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HeadquartersToolsO2OWithCallback invokes the cloudwf.HeadquartersToolsO2O API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolso2o.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersToolsO2OWithCallback(request *HeadquartersToolsO2ORequest, callback func(response *HeadquartersToolsO2OResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HeadquartersToolsO2OResponse
		var err error
		defer close(result)
		response, err = client.HeadquartersToolsO2O(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HeadquartersToolsO2ORequest is the request struct for api HeadquartersToolsO2O
type HeadquartersToolsO2ORequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// HeadquartersToolsO2OResponse is the response struct for api HeadquartersToolsO2O
type HeadquartersToolsO2OResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateHeadquartersToolsO2ORequest creates a request to invoke HeadquartersToolsO2O API
func CreateHeadquartersToolsO2ORequest() (request *HeadquartersToolsO2ORequest) {
	request = &HeadquartersToolsO2ORequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "HeadquartersToolsO2O", "cloudwf", "openAPI")
	return
}

// CreateHeadquartersToolsO2OResponse creates a response to parse from HeadquartersToolsO2O response
func CreateHeadquartersToolsO2OResponse() (response *HeadquartersToolsO2OResponse) {
	response = &HeadquartersToolsO2OResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
