package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPhotoFaces invokes the cloudphoto.ListPhotoFaces API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotofaces.html
func (client *Client) ListPhotoFaces(request *ListPhotoFacesRequest) (response *ListPhotoFacesResponse, err error) {
	response = CreateListPhotoFacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListPhotoFacesWithChan invokes the cloudphoto.ListPhotoFaces API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotofaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoFacesWithChan(request *ListPhotoFacesRequest) (<-chan *ListPhotoFacesResponse, <-chan error) {
	responseChan := make(chan *ListPhotoFacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPhotoFaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPhotoFacesWithCallback invokes the cloudphoto.ListPhotoFaces API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotofaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoFacesWithCallback(request *ListPhotoFacesRequest, callback func(response *ListPhotoFacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPhotoFacesResponse
		var err error
		defer close(result)
		response, err = client.ListPhotoFaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPhotoFacesRequest is the request struct for api ListPhotoFaces
type ListPhotoFacesRequest struct {
	*requests.RpcRequest
	LibraryId string           `position:"Query" name:"LibraryId"`
	PhotoId   requests.Integer `position:"Query" name:"PhotoId"`
	StoreName string           `position:"Query" name:"StoreName"`
}

// ListPhotoFacesResponse is the response struct for api ListPhotoFaces
type ListPhotoFacesResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Action    string `json:"Action" xml:"Action"`
	Faces     []Face `json:"Faces" xml:"Faces"`
}

// CreateListPhotoFacesRequest creates a request to invoke ListPhotoFaces API
func CreateListPhotoFacesRequest() (request *ListPhotoFacesRequest) {
	request = &ListPhotoFacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ListPhotoFaces", "cloudphoto", "openAPI")
	return
}

// CreateListPhotoFacesResponse creates a response to parse from ListPhotoFaces response
func CreateListPhotoFacesResponse() (response *ListPhotoFacesResponse) {
	response = &ListPhotoFacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
