#!/bin/sh

set -e
set -u
set -x

# Test that setting v0 compatibility mode via env var works.
EXP1="hello"
OUT1="$(RQ_REGO_V0=yes "$RQ" script ./script1.rq)"
if [ "$OUT1" != "$EXP1" ] ; then
	printf "expected output '%s' but got:\n%s\n" "$EXP1" "$OUT1"
	exit 1
fi

# Test that setting v0 compatibility mode via script directive works.
EXP2="hello"
OUT2="$("$RQ" script ./script2.rq)"
if [ "$OUT2" != "$EXP2" ] ; then
	printf "expected output '%s' but got:\n%s\n" "$EXP2" "$OUT2"
	exit 1
fi
