#!/bin/sh

# This test ensures that the --check flag works as expected.

set -e
set -u
set -x

TEMP="$(mktemp -d)"
trap "rm -rf '$TEMP'" EXIT

tcase() {
	# $1 . . . rego value
	# $2 . . . 1 if we expect nonzero exit code

	set +e
	OUT="$("$RQ" --check "$1")"
	S=$?
	set -e

	if [ $2 -eq 1 ] ; then
		if [ $S -eq 0 ] ; then
			printf 'rq query --check "%s" should have exited nonzero, but did not\n' "$1"
			exit 1
		fi
	else
		if [ $S -ne 0 ] ; then
			printf 'rq query --check "%s" should not have exited nonzero, but did\n' "$1"
			exit 1
		fi
	fi

	# Only tangentially part of the test, this code-generates a version of
	# the script with the provided value subbed in. 
	rv="$1" "$RQ" \
		-O "raw:$TEMP/script.rq" \
		-I raw:./script.templ \
		'rq.template(input, {"regovalue": rq.env()["rv"]})'

	set +e
	OUT="$("$RQ" script "$TEMP/script.rq")"
	S=$?
	set -e

	if [ $2 -eq 1 ] ; then
		if [ $S -eq 0 ] ; then
			printf 'rq script (check enabled) "%s" should have exited nonzero, but did not\n' "$1"
			exit 1
		fi
	else
		if [ $S -ne 0 ] ; then
			printf 'rq script (check enabled) "%s" should not have exited nonzero, but did\n' "$1"
			exit 1
		fi
	fi

}

tcase '""' 1
tcase '0' 1
tcase '0.0' 1
tcase '{}' 1
tcase '[]' 1
tcase 'set()' 1
tcase '[{}]' 0
tcase '1' 0
tcase '"hi"' 0
tcase '{"foo":1}' 0
tcase '[1]' 0
