#!/bin/sh

cd "$(dirname "$0")/.."
set -e
set -u

TEMP="$(mktemp -d)"
trap "rm -rf '$TEMP'" EXIT

make clean
rm -rf ./release
make rq

VERSION="$(./build/rq -R 'rq.version().version' | sed 's/ (dev)/-dev/g')"
echo "detected version '$VERSION'"
make clean

mkdir -p "$TEMP/rq"
cp -R ./* "$TEMP/rq"

mkdir ./release

START="$(pwd)"

# prepare the source tarball
echo "preparing source tarball..."
cd "$TEMP/rq"
go mod vendor
cd ..
tar cfz "$START/release/rq-src-$VERSION.tar.gz" ./rq

# prepare the binary releases
cd "$START"
for PLATFORM in darwin/amd64 darwin/arm64 linux/amd64 linux/arm64 linux/arm linux/386 windows/amd64 windows/386 windows/arm windows/arm64 ; do
	echo "building for platform $PLATFORM..."
	export GOOS="$(echo "$PLATFORM" | cut -d/ -f1)"
	export GOARCH="$(echo "$PLATFORM" | cut -d/ -f2)"
	BIN="rq-$GOOS-$GOARCH-$VERSION"
	go build -o "$BIN" -ldflags="-s -w" ./cmd/rq
	gzip < "$BIN" > "$START/release/$BIN.gz"
	rm -f "$START/$BIN"
done
