package io

import (
	"io"

	"gopkg.in/yaml.v3"
)

func init() {
	registerInputHandler("yaml", func() InputHandler { return &YAMLInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &YAMLInputHandler{}

// YAMLInputHandler handles parsing YAML data.
type YAMLInputHandler struct{}

// Name implements InputHandler.Name().
func (y *YAMLInputHandler) Name() string {
	return "yaml"
}

// Parse implements InputHandler.Parse().
func (y *YAMLInputHandler) Parse(reader io.Reader) (interface{}, error) {
	inputBytes, err := io.ReadAll(reader)
	if err != nil {
		return nil, err
	}

	var parsed interface{}
	err = yaml.Unmarshal(inputBytes, &parsed)
	if err != nil {
		return nil, err
	}

	return parsed, nil
}

// SetOption implements InputHandler.SetOption().
func (y *YAMLInputHandler) SetOption(name string, value string) error {
	// The YAML handler does not have any options.
	return nil
}
