/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.event.hierarchy;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.flexdock.docking.DockingPort;
import org.flexdock.util.RootWindow;

public class RootDockingPortInfo {
    private WeakReference windowRef;
    private ArrayList rootPorts;
    private HashMap portsById;
    private String mainPortId;

    public RootDockingPortInfo(RootWindow window) {
        this.windowRef = new WeakReference<RootWindow>(window);
        this.rootPorts = new ArrayList(2);
        this.portsById = new HashMap(2);
    }

    public RootWindow getWindow() {
        return (RootWindow)this.windowRef.get();
    }

    private boolean containsPortId(DockingPort port) {
        return port == null ? false : this.contains(port.getPersistentId());
    }

    public boolean contains(String portId) {
        return portId == null ? false : this.portsById.containsKey(portId);
    }

    public boolean contains(DockingPort port) {
        return port == null ? false : this.portsById.containsValue(port);
    }

    public synchronized void add(DockingPort port) {
        if (this.containsPortId(port)) {
            return;
        }
        this.portsById.put(port.getPersistentId(), port);
        this.rootPorts.add(port);
    }

    public synchronized void remove(DockingPort port) {
        if (port == null) {
            return;
        }
        String key = port.getPersistentId();
        if (!this.contains(key)) {
            key = null;
            Iterator it = this.portsById.keySet().iterator();
            while (it.hasNext()) {
                String tmpKey = (String)it.next();
                DockingPort tmp = (DockingPort)this.portsById.get(tmpKey);
                if (tmp != port) continue;
                key = tmpKey;
                break;
            }
        }
        if (key != null) {
            this.portsById.remove(key);
        }
        this.rootPorts.remove(port);
    }

    public int getPortCount() {
        return this.rootPorts.size();
    }

    public DockingPort getPort(int indx) {
        return indx < this.getPortCount() ? (DockingPort)this.rootPorts.get(indx) : null;
    }

    public DockingPort getPort(String portId) {
        return (DockingPort)this.portsById.get(portId);
    }

    public void setMainPort(String portId) {
        this.mainPortId = portId;
    }

    public DockingPort getMainPort() {
        DockingPort port;
        DockingPort dockingPort = port = this.mainPortId == null ? null : this.getPort(this.mainPortId);
        if (port == null) {
            port = this.getPortCount() > 0 ? this.getPort(0) : null;
        }
        return port;
    }
}

