use clap::ValueEnum;
use forgejo_api::structs::MigrateRepoOptionsService;
use strum::{Display, EnumIter, EnumString};

#[derive(Debug, Clone, Copy, Default, PartialEq, Eq, Display, EnumString, ValueEnum, EnumIter)]
pub enum Service {
    #[default]
    Git,
    Github,
    Gitea,
    Gitlab,
    Gogs,
    Onedev,
    Gitbucket,
    Codebase,
}

impl From<MigrateRepoOptionsService> for Service {
    fn from(value: MigrateRepoOptionsService) -> Self {
        match value {
            MigrateRepoOptionsService::Git => Self::Git,
            MigrateRepoOptionsService::Github => Self::Github,
            MigrateRepoOptionsService::Gitea => Self::Gitea,
            MigrateRepoOptionsService::Gitlab => Self::Gitlab,
            MigrateRepoOptionsService::Gogs => Self::Gogs,
            MigrateRepoOptionsService::Onedev => Self::Onedev,
            MigrateRepoOptionsService::Gitbucket => Self::Gitbucket,
            MigrateRepoOptionsService::Codebase => Self::Codebase,
        }
    }
}

impl From<Service> for MigrateRepoOptionsService {
    fn from(value: Service) -> MigrateRepoOptionsService {
        match value {
            Service::Git => Self::Git,
            Service::Github => Self::Github,
            Service::Gitea => Self::Gitea,
            Service::Gitlab => Self::Gitlab,
            Service::Gogs => Self::Gogs,
            Service::Onedev => Self::Onedev,
            Service::Gitbucket => Self::Gitbucket,
            Service::Codebase => Self::Codebase,
        }
    }
}
