use time::{OffsetDateTime, format_description};

pub fn render_comment(username: &str, creation_time: &OffsetDateTime, comment: &str) -> String {
    const PARENTHESES: usize = 2;
    const COLON: usize = 1;

    let creation_time_formatted = creation_time
        .format(
            &format_description::parse("[day].[month].[year] - [hour]:[minute]")
                .expect("invalid DateTime format"),
        )
        .expect("Couldn't format DateTime'");

    format!(
        "{}\n({}):\n{}\n\n{}",
        username,
        creation_time_formatted,
        "=".repeat(creation_time_formatted.len() + PARENTHESES + COLON),
        comment
    )
}
