use forgejo_api::{Auth, Forgejo};
use miette::IntoDiagnostic;
use url::Url;

use crate::types::token::Token;

use crate::client::BergClient;

impl BergClient {
    pub fn new(token: &Token, base_url: Url) -> miette::Result<Self> {
        let Token(token) = token;
        Forgejo::with_user_agent(Auth::Token(token), base_url, "codeberg-cli")
            .map(Self)
            .into_diagnostic()
    }
}
