pub mod delete;
pub mod list;

use clap::Subcommand;

use super::super::GlobalArgs;

/// Branch subcommands
#[derive(Subcommand, Debug)]
pub enum BranchArgs {
    /// List branches
    List(list::RepoBranchesArgs),
    /// Delete a branch
    Delete(delete::RepoBranchDeleteArgs),
}

impl BranchArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            BranchArgs::List(args) => args.run(global_args).await,
            BranchArgs::Delete(args) => args.run(global_args).await,
        }
    }
}
