use crate::actions::GlobalArgs;
use crate::actions::keys::gpg::gpg_key_identifier;
use crate::render::json::JsonToStdout;
use crate::types::context::BergContext;

use clap::Parser;
use itertools::Itertools;
use miette::IntoDiagnostic;

/// List all available gpg keys
#[derive(Parser, Debug)]
pub struct ListGpgArgs {}

impl ListGpgArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let _ = global_args;
        let ctx = BergContext::new(self, global_args).await?;

        let (_, gpg_keys) = ctx
            .client
            .user_current_list_gpg_keys()
            .await
            .into_diagnostic()?;

        match ctx.global_args.output_mode {
            crate::types::output::OutputMode::Pretty => {
                let key_output = gpg_keys.iter().map(gpg_key_identifier).join("\n");
                println!("{key_output}");
            }
            crate::types::output::OutputMode::Json => gpg_keys.print_json()?,
        }

        Ok(())
    }
}
