pub mod generate;
pub mod info;

use clap::Subcommand;

use super::GlobalArgs;

/// Config subcommands
#[derive(Subcommand, Debug)]
pub enum ConfigArgs {
    Info(info::ConfigInfoArgs),
    Generate(generate::ConfigGenerateArgs),
}

impl ConfigArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            ConfigArgs::Info(args) => args.run(global_args),
            ConfigArgs::Generate(args) => args.run(global_args),
        }
    }
}
