{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks = tapeTestLib.embeddInFlake {
        userInfo = {
          extraSetup = [
            "berg auth login --token TOKEN"
            "berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}"
          ];
          exec = [
            "Sleep 2s"
            ''Type "berg user info"''
            "Sleep 2s"
            "Enter"
            "Sleep 3s"
          ];
        };
      };
    };
}
