{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks = tapeTestLib.embeddInFlake {
        pullCreate = {
          extraSetup = [
            ''berg auth login --token TOKEN''
            ''berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}''
            ''berg repo clone ${sharedLib.user}/${sharedLib.repo}''
            ''cd ${sharedLib.repo}''
            ''git checkout -b ${sharedLib.main}''
            ''echo 'Hello, World!' > hello.txt''
            ''git add -A''
            ''git commit -m 'Hello, World!' ''
            ''git push origin ${sharedLib.main}''
          ];
          exec =
            (
              [
                ''# Create a new commit on a new branch''
                ''git checkout -b ${sharedLib.branch}''
                ''echo 'Bye, World!' > bye.txt''
                ''git add -A''
                ''git commit -m 'Bye, World!' ''
                ''git push origin ${sharedLib.branch}''
              ]
              |> builtins.map (cmd: ''
                Type "${cmd}"
                Enter
                Sleep 250ms
              '')
            )
            ++ [
              ''Wait+Screen /new branch/''
              ''Sleep 500ms''
              ''Type "berg --non-interactive pull create --title First --target-branch ${sharedLib.main}"''
              ''Enter''
              ''Sleep 5s''
            ];
        };
      };
    };
}
