pub mod generate;
pub mod info;

use clap::Subcommand;

use super::GeneralArgs;

/// Config subcommands
#[derive(Subcommand, Debug)]
pub enum ConfigArgs {
    Info(info::ConfigInfoArgs),
    Generate(generate::ConfigGenerateArgs),
}

impl ConfigArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            ConfigArgs::Info(args) => args.run(general_args),
            ConfigArgs::Generate(args) => args.run(general_args),
        }
    }
}
