use time::{format_description, OffsetDateTime};

use crate::types::config::BergConfig;

pub fn render_comment(
    config: &BergConfig,
    username: &str,
    creation_time: &OffsetDateTime,
    comment: &str,
) -> String {
    let mut table = config.make_table();

    const PARENTHESES: usize = 2;
    const COLON: usize = 1;

    let creation_time_formatted = creation_time
        .format(
            &format_description::parse("[day].[month].[year] - [hour]:[minute]")
                .expect("invalid DateTime format"),
        )
        .expect("Couldn't format DateTime'");

    table.add_row(vec![comment]);

    format!(
        "{}\n({}):\n{}\n\n{}",
        username,
        creation_time_formatted,
        "=".repeat(creation_time_formatted.len() + PARENTHESES + COLON),
        table.show()
    )
}
