use forgejo_api::structs::User;

use crate::actions::GeneralArgs;
use crate::render::option::option_display;
use crate::render::spinner::spin_until_ready;
use crate::types::context::BergContext;
use crate::types::git::OwnerRepo;

use clap::Parser;

/// List available assignee candidates
#[derive(Parser, Debug)]
pub struct RepoAssigneesArgs {}

impl RepoAssigneesArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        let _ = general_args;
        let ctx = BergContext::new(self, general_args).await?;

        let OwnerRepo { repo, owner } = ctx.owner_repo()?;
        let repo_assignees =
            spin_until_ready(ctx.client.repo_get_assignees(owner.as_str(), repo.as_str())).await?;

        present_repo_assignees(&ctx, repo_assignees);

        Ok(())
    }
}

fn present_repo_assignees(ctx: &BergContext<RepoAssigneesArgs>, repo_assignees: Vec<User>) {
    let mut table = ctx.make_table();

    table
        .set_header(vec![format!(
            "Repository Assignees{}",
            repo_assignees
                .is_empty()
                .then_some(" (empty)")
                .unwrap_or_default()
        )])
        .add_rows(
            repo_assignees
                .into_iter()
                .map(|assignee| vec![option_display(&assignee.login)]),
        );

    println!("{table}", table = table.show());
}
