pub mod list;
pub mod view;

use clap::Subcommand;

use super::GeneralArgs;

/// Notification subcommands
#[derive(Debug, Subcommand)]
pub enum NotificationArgs {
    List(list::ListNotificationArgs),
    View(view::ViewNotificationArgs),
}

impl NotificationArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            NotificationArgs::List(args) => args.run(general_args).await,
            NotificationArgs::View(args) => args.run(general_args).await,
        }
    }
}
