use crate::{actions::GeneralArgs, types::context::BergContext};

use clap::Parser;

/// Display short summary of the authenticated user account
#[derive(Parser, Debug)]
pub struct ApiVersionArgs {}

impl ApiVersionArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        let _ = general_args;
        let ctx = BergContext::new(self, general_args).await?;
        let version = ctx.client.get_version().await?;

        println!("{version:?}");

        Ok(())
    }
}
