// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package control

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"regexp"
	"strings"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	controlpb "cloud.google.com/go/storage/control/apiv2/controlpb"
	"github.com/google/uuid"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newStorageControlClientHook clientHook

// StorageControlCallOptions contains the retry settings for each method of StorageControlClient.
type StorageControlCallOptions struct {
	CreateFolder                         []gax.CallOption
	DeleteFolder                         []gax.CallOption
	GetFolder                            []gax.CallOption
	ListFolders                          []gax.CallOption
	RenameFolder                         []gax.CallOption
	GetStorageLayout                     []gax.CallOption
	CreateManagedFolder                  []gax.CallOption
	DeleteManagedFolder                  []gax.CallOption
	GetManagedFolder                     []gax.CallOption
	ListManagedFolders                   []gax.CallOption
	CreateAnywhereCache                  []gax.CallOption
	UpdateAnywhereCache                  []gax.CallOption
	DisableAnywhereCache                 []gax.CallOption
	PauseAnywhereCache                   []gax.CallOption
	ResumeAnywhereCache                  []gax.CallOption
	GetAnywhereCache                     []gax.CallOption
	ListAnywhereCaches                   []gax.CallOption
	GetProjectIntelligenceConfig         []gax.CallOption
	UpdateProjectIntelligenceConfig      []gax.CallOption
	GetFolderIntelligenceConfig          []gax.CallOption
	UpdateFolderIntelligenceConfig       []gax.CallOption
	GetOrganizationIntelligenceConfig    []gax.CallOption
	UpdateOrganizationIntelligenceConfig []gax.CallOption
}

func defaultStorageControlGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("storage.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("storage.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("storage.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://storage.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultStorageControlCallOptions() *StorageControlCallOptions {
	return &StorageControlCallOptions{
		CreateFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		DeleteFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		ListFolders: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		RenameFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		GetStorageLayout: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		CreateManagedFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteManagedFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetManagedFolder: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		ListManagedFolders: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		CreateAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		UpdateAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		DisableAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		PauseAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		ResumeAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		GetAnywhereCache: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		ListAnywhereCaches: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		GetProjectIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		UpdateProjectIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		GetFolderIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		UpdateFolderIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		GetOrganizationIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
		UpdateOrganizationIntelligenceConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.ResourceExhausted,
					codes.Unavailable,
					codes.DeadlineExceeded,
					codes.Internal,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 2.00,
				})
			}),
		},
	}
}

// internalStorageControlClient is an interface that defines the methods available from Storage Control API.
type internalStorageControlClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateFolder(context.Context, *controlpb.CreateFolderRequest, ...gax.CallOption) (*controlpb.Folder, error)
	DeleteFolder(context.Context, *controlpb.DeleteFolderRequest, ...gax.CallOption) error
	GetFolder(context.Context, *controlpb.GetFolderRequest, ...gax.CallOption) (*controlpb.Folder, error)
	ListFolders(context.Context, *controlpb.ListFoldersRequest, ...gax.CallOption) *FolderIterator
	RenameFolder(context.Context, *controlpb.RenameFolderRequest, ...gax.CallOption) (*RenameFolderOperation, error)
	RenameFolderOperation(name string) *RenameFolderOperation
	GetStorageLayout(context.Context, *controlpb.GetStorageLayoutRequest, ...gax.CallOption) (*controlpb.StorageLayout, error)
	CreateManagedFolder(context.Context, *controlpb.CreateManagedFolderRequest, ...gax.CallOption) (*controlpb.ManagedFolder, error)
	DeleteManagedFolder(context.Context, *controlpb.DeleteManagedFolderRequest, ...gax.CallOption) error
	GetManagedFolder(context.Context, *controlpb.GetManagedFolderRequest, ...gax.CallOption) (*controlpb.ManagedFolder, error)
	ListManagedFolders(context.Context, *controlpb.ListManagedFoldersRequest, ...gax.CallOption) *ManagedFolderIterator
	CreateAnywhereCache(context.Context, *controlpb.CreateAnywhereCacheRequest, ...gax.CallOption) (*CreateAnywhereCacheOperation, error)
	CreateAnywhereCacheOperation(name string) *CreateAnywhereCacheOperation
	UpdateAnywhereCache(context.Context, *controlpb.UpdateAnywhereCacheRequest, ...gax.CallOption) (*UpdateAnywhereCacheOperation, error)
	UpdateAnywhereCacheOperation(name string) *UpdateAnywhereCacheOperation
	DisableAnywhereCache(context.Context, *controlpb.DisableAnywhereCacheRequest, ...gax.CallOption) (*controlpb.AnywhereCache, error)
	PauseAnywhereCache(context.Context, *controlpb.PauseAnywhereCacheRequest, ...gax.CallOption) (*controlpb.AnywhereCache, error)
	ResumeAnywhereCache(context.Context, *controlpb.ResumeAnywhereCacheRequest, ...gax.CallOption) (*controlpb.AnywhereCache, error)
	GetAnywhereCache(context.Context, *controlpb.GetAnywhereCacheRequest, ...gax.CallOption) (*controlpb.AnywhereCache, error)
	ListAnywhereCaches(context.Context, *controlpb.ListAnywhereCachesRequest, ...gax.CallOption) *AnywhereCacheIterator
	GetProjectIntelligenceConfig(context.Context, *controlpb.GetProjectIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
	UpdateProjectIntelligenceConfig(context.Context, *controlpb.UpdateProjectIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
	GetFolderIntelligenceConfig(context.Context, *controlpb.GetFolderIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
	UpdateFolderIntelligenceConfig(context.Context, *controlpb.UpdateFolderIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
	GetOrganizationIntelligenceConfig(context.Context, *controlpb.GetOrganizationIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
	UpdateOrganizationIntelligenceConfig(context.Context, *controlpb.UpdateOrganizationIntelligenceConfigRequest, ...gax.CallOption) (*controlpb.IntelligenceConfig, error)
}

// StorageControlClient is a client for interacting with Storage Control API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// StorageControl service includes selected control plane operations.
type StorageControlClient struct {
	// The internal transport-dependent client.
	internalClient internalStorageControlClient

	// The call options for this service.
	CallOptions *StorageControlCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *StorageControlClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *StorageControlClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *StorageControlClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateFolder creates a new folder. This operation is only applicable to a hierarchical
// namespace enabled bucket.
func (c *StorageControlClient) CreateFolder(ctx context.Context, req *controlpb.CreateFolderRequest, opts ...gax.CallOption) (*controlpb.Folder, error) {
	return c.internalClient.CreateFolder(ctx, req, opts...)
}

// DeleteFolder permanently deletes an empty folder. This operation is only applicable to a
// hierarchical namespace enabled bucket.
func (c *StorageControlClient) DeleteFolder(ctx context.Context, req *controlpb.DeleteFolderRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteFolder(ctx, req, opts...)
}

// GetFolder returns metadata for the specified folder. This operation is only
// applicable to a hierarchical namespace enabled bucket.
func (c *StorageControlClient) GetFolder(ctx context.Context, req *controlpb.GetFolderRequest, opts ...gax.CallOption) (*controlpb.Folder, error) {
	return c.internalClient.GetFolder(ctx, req, opts...)
}

// ListFolders retrieves a list of folders. This operation is only applicable to a
// hierarchical namespace enabled bucket.
func (c *StorageControlClient) ListFolders(ctx context.Context, req *controlpb.ListFoldersRequest, opts ...gax.CallOption) *FolderIterator {
	return c.internalClient.ListFolders(ctx, req, opts...)
}

// RenameFolder renames a source folder to a destination folder. This operation is only
// applicable to a hierarchical namespace enabled bucket. During a rename, the
// source and destination folders are locked until the long running operation
// completes.
func (c *StorageControlClient) RenameFolder(ctx context.Context, req *controlpb.RenameFolderRequest, opts ...gax.CallOption) (*RenameFolderOperation, error) {
	return c.internalClient.RenameFolder(ctx, req, opts...)
}

// RenameFolderOperation returns a new RenameFolderOperation from a given name.
// The name must be that of a previously created RenameFolderOperation, possibly from a different process.
func (c *StorageControlClient) RenameFolderOperation(name string) *RenameFolderOperation {
	return c.internalClient.RenameFolderOperation(name)
}

// GetStorageLayout returns the storage layout configuration for a given bucket.
func (c *StorageControlClient) GetStorageLayout(ctx context.Context, req *controlpb.GetStorageLayoutRequest, opts ...gax.CallOption) (*controlpb.StorageLayout, error) {
	return c.internalClient.GetStorageLayout(ctx, req, opts...)
}

// CreateManagedFolder creates a new managed folder.
func (c *StorageControlClient) CreateManagedFolder(ctx context.Context, req *controlpb.CreateManagedFolderRequest, opts ...gax.CallOption) (*controlpb.ManagedFolder, error) {
	return c.internalClient.CreateManagedFolder(ctx, req, opts...)
}

// DeleteManagedFolder permanently deletes an empty managed folder.
func (c *StorageControlClient) DeleteManagedFolder(ctx context.Context, req *controlpb.DeleteManagedFolderRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteManagedFolder(ctx, req, opts...)
}

// GetManagedFolder returns metadata for the specified managed folder.
func (c *StorageControlClient) GetManagedFolder(ctx context.Context, req *controlpb.GetManagedFolderRequest, opts ...gax.CallOption) (*controlpb.ManagedFolder, error) {
	return c.internalClient.GetManagedFolder(ctx, req, opts...)
}

// ListManagedFolders retrieves a list of managed folders for a given bucket.
func (c *StorageControlClient) ListManagedFolders(ctx context.Context, req *controlpb.ListManagedFoldersRequest, opts ...gax.CallOption) *ManagedFolderIterator {
	return c.internalClient.ListManagedFolders(ctx, req, opts...)
}

// CreateAnywhereCache creates an Anywhere Cache instance.
func (c *StorageControlClient) CreateAnywhereCache(ctx context.Context, req *controlpb.CreateAnywhereCacheRequest, opts ...gax.CallOption) (*CreateAnywhereCacheOperation, error) {
	return c.internalClient.CreateAnywhereCache(ctx, req, opts...)
}

// CreateAnywhereCacheOperation returns a new CreateAnywhereCacheOperation from a given name.
// The name must be that of a previously created CreateAnywhereCacheOperation, possibly from a different process.
func (c *StorageControlClient) CreateAnywhereCacheOperation(name string) *CreateAnywhereCacheOperation {
	return c.internalClient.CreateAnywhereCacheOperation(name)
}

// UpdateAnywhereCache updates an Anywhere Cache instance. Mutable fields include ttl and
// admission_policy.
func (c *StorageControlClient) UpdateAnywhereCache(ctx context.Context, req *controlpb.UpdateAnywhereCacheRequest, opts ...gax.CallOption) (*UpdateAnywhereCacheOperation, error) {
	return c.internalClient.UpdateAnywhereCache(ctx, req, opts...)
}

// UpdateAnywhereCacheOperation returns a new UpdateAnywhereCacheOperation from a given name.
// The name must be that of a previously created UpdateAnywhereCacheOperation, possibly from a different process.
func (c *StorageControlClient) UpdateAnywhereCacheOperation(name string) *UpdateAnywhereCacheOperation {
	return c.internalClient.UpdateAnywhereCacheOperation(name)
}

// DisableAnywhereCache disables an Anywhere Cache instance. A disabled instance is read-only. The
// disablement could be revoked by calling ResumeAnywhereCache. The cache
// instance will be deleted automatically if it remains in the disabled state
// for at least one hour.
func (c *StorageControlClient) DisableAnywhereCache(ctx context.Context, req *controlpb.DisableAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	return c.internalClient.DisableAnywhereCache(ctx, req, opts...)
}

// PauseAnywhereCache pauses an Anywhere Cache instance.
func (c *StorageControlClient) PauseAnywhereCache(ctx context.Context, req *controlpb.PauseAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	return c.internalClient.PauseAnywhereCache(ctx, req, opts...)
}

// ResumeAnywhereCache resumes a disabled or paused Anywhere Cache instance.
func (c *StorageControlClient) ResumeAnywhereCache(ctx context.Context, req *controlpb.ResumeAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	return c.internalClient.ResumeAnywhereCache(ctx, req, opts...)
}

// GetAnywhereCache gets an Anywhere Cache instance.
func (c *StorageControlClient) GetAnywhereCache(ctx context.Context, req *controlpb.GetAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	return c.internalClient.GetAnywhereCache(ctx, req, opts...)
}

// ListAnywhereCaches lists Anywhere Cache instances for a given bucket.
func (c *StorageControlClient) ListAnywhereCaches(ctx context.Context, req *controlpb.ListAnywhereCachesRequest, opts ...gax.CallOption) *AnywhereCacheIterator {
	return c.internalClient.ListAnywhereCaches(ctx, req, opts...)
}

// GetProjectIntelligenceConfig returns the Project scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) GetProjectIntelligenceConfig(ctx context.Context, req *controlpb.GetProjectIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.GetProjectIntelligenceConfig(ctx, req, opts...)
}

// UpdateProjectIntelligenceConfig updates the Project scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) UpdateProjectIntelligenceConfig(ctx context.Context, req *controlpb.UpdateProjectIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.UpdateProjectIntelligenceConfig(ctx, req, opts...)
}

// GetFolderIntelligenceConfig returns the Folder scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) GetFolderIntelligenceConfig(ctx context.Context, req *controlpb.GetFolderIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.GetFolderIntelligenceConfig(ctx, req, opts...)
}

// UpdateFolderIntelligenceConfig updates the Folder scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) UpdateFolderIntelligenceConfig(ctx context.Context, req *controlpb.UpdateFolderIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.UpdateFolderIntelligenceConfig(ctx, req, opts...)
}

// GetOrganizationIntelligenceConfig returns the Organization scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) GetOrganizationIntelligenceConfig(ctx context.Context, req *controlpb.GetOrganizationIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.GetOrganizationIntelligenceConfig(ctx, req, opts...)
}

// UpdateOrganizationIntelligenceConfig updates the Organization scoped singleton IntelligenceConfig resource.
func (c *StorageControlClient) UpdateOrganizationIntelligenceConfig(ctx context.Context, req *controlpb.UpdateOrganizationIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	return c.internalClient.UpdateOrganizationIntelligenceConfig(ctx, req, opts...)
}

// storageControlGRPCClient is a client for interacting with Storage Control API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type storageControlGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing StorageControlClient
	CallOptions **StorageControlCallOptions

	// The gRPC API client.
	storageControlClient controlpb.StorageControlClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewStorageControlClient creates a new storage control client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// StorageControl service includes selected control plane operations.
func NewStorageControlClient(ctx context.Context, opts ...option.ClientOption) (*StorageControlClient, error) {
	clientOpts := defaultStorageControlGRPCClientOptions()
	if newStorageControlClientHook != nil {
		hookOpts, err := newStorageControlClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := StorageControlClient{CallOptions: defaultStorageControlCallOptions()}

	c := &storageControlGRPCClient{
		connPool:             connPool,
		storageControlClient: controlpb.NewStorageControlClient(connPool),
		CallOptions:          &client.CallOptions,
		logger:               internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *storageControlGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *storageControlGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *storageControlGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *storageControlGRPCClient) CreateFolder(ctx context.Context, req *controlpb.CreateFolderRequest, opts ...gax.CallOption) (*controlpb.Folder, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).CreateFolder[0:len((*c.CallOptions).CreateFolder):len((*c.CallOptions).CreateFolder)], opts...)
	var resp *controlpb.Folder
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.CreateFolder, req, settings.GRPC, c.logger, "CreateFolder")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) DeleteFolder(ctx context.Context, req *controlpb.DeleteFolderRequest, opts ...gax.CallOption) error {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).DeleteFolder[0:len((*c.CallOptions).DeleteFolder):len((*c.CallOptions).DeleteFolder)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.storageControlClient.DeleteFolder, req, settings.GRPC, c.logger, "DeleteFolder")
		return err
	}, opts...)
	return err
}

func (c *storageControlGRPCClient) GetFolder(ctx context.Context, req *controlpb.GetFolderRequest, opts ...gax.CallOption) (*controlpb.Folder, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).GetFolder[0:len((*c.CallOptions).GetFolder):len((*c.CallOptions).GetFolder)], opts...)
	var resp *controlpb.Folder
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetFolder, req, settings.GRPC, c.logger, "GetFolder")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) ListFolders(ctx context.Context, req *controlpb.ListFoldersRequest, opts ...gax.CallOption) *FolderIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListFolders[0:len((*c.CallOptions).ListFolders):len((*c.CallOptions).ListFolders)], opts...)
	it := &FolderIterator{}
	req = proto.Clone(req).(*controlpb.ListFoldersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*controlpb.Folder, string, error) {
		resp := &controlpb.ListFoldersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.storageControlClient.ListFolders, req, settings.GRPC, c.logger, "ListFolders")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetFolders(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *storageControlGRPCClient) RenameFolder(ctx context.Context, req *controlpb.RenameFolderRequest, opts ...gax.CallOption) (*RenameFolderOperation, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RenameFolder[0:len((*c.CallOptions).RenameFolder):len((*c.CallOptions).RenameFolder)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.RenameFolder, req, settings.GRPC, c.logger, "RenameFolder")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RenameFolderOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *storageControlGRPCClient) GetStorageLayout(ctx context.Context, req *controlpb.GetStorageLayoutRequest, opts ...gax.CallOption) (*controlpb.StorageLayout, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).GetStorageLayout[0:len((*c.CallOptions).GetStorageLayout):len((*c.CallOptions).GetStorageLayout)], opts...)
	var resp *controlpb.StorageLayout
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetStorageLayout, req, settings.GRPC, c.logger, "GetStorageLayout")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) CreateManagedFolder(ctx context.Context, req *controlpb.CreateManagedFolderRequest, opts ...gax.CallOption) (*controlpb.ManagedFolder, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).CreateManagedFolder[0:len((*c.CallOptions).CreateManagedFolder):len((*c.CallOptions).CreateManagedFolder)], opts...)
	var resp *controlpb.ManagedFolder
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.CreateManagedFolder, req, settings.GRPC, c.logger, "CreateManagedFolder")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) DeleteManagedFolder(ctx context.Context, req *controlpb.DeleteManagedFolderRequest, opts ...gax.CallOption) error {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).DeleteManagedFolder[0:len((*c.CallOptions).DeleteManagedFolder):len((*c.CallOptions).DeleteManagedFolder)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.storageControlClient.DeleteManagedFolder, req, settings.GRPC, c.logger, "DeleteManagedFolder")
		return err
	}, opts...)
	return err
}

func (c *storageControlGRPCClient) GetManagedFolder(ctx context.Context, req *controlpb.GetManagedFolderRequest, opts ...gax.CallOption) (*controlpb.ManagedFolder, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).GetManagedFolder[0:len((*c.CallOptions).GetManagedFolder):len((*c.CallOptions).GetManagedFolder)], opts...)
	var resp *controlpb.ManagedFolder
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetManagedFolder, req, settings.GRPC, c.logger, "GetManagedFolder")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) ListManagedFolders(ctx context.Context, req *controlpb.ListManagedFoldersRequest, opts ...gax.CallOption) *ManagedFolderIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListManagedFolders[0:len((*c.CallOptions).ListManagedFolders):len((*c.CallOptions).ListManagedFolders)], opts...)
	it := &ManagedFolderIterator{}
	req = proto.Clone(req).(*controlpb.ListManagedFoldersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*controlpb.ManagedFolder, string, error) {
		resp := &controlpb.ListManagedFoldersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.storageControlClient.ListManagedFolders, req, settings.GRPC, c.logger, "ListManagedFolders")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetManagedFolders(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *storageControlGRPCClient) CreateAnywhereCache(ctx context.Context, req *controlpb.CreateAnywhereCacheRequest, opts ...gax.CallOption) (*CreateAnywhereCacheOperation, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAnywhereCache[0:len((*c.CallOptions).CreateAnywhereCache):len((*c.CallOptions).CreateAnywhereCache)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.CreateAnywhereCache, req, settings.GRPC, c.logger, "CreateAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAnywhereCacheOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *storageControlGRPCClient) UpdateAnywhereCache(ctx context.Context, req *controlpb.UpdateAnywhereCacheRequest, opts ...gax.CallOption) (*UpdateAnywhereCacheOperation, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetAnywhereCache().GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetAnywhereCache().GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetAnywhereCache().GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAnywhereCache[0:len((*c.CallOptions).UpdateAnywhereCache):len((*c.CallOptions).UpdateAnywhereCache)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.UpdateAnywhereCache, req, settings.GRPC, c.logger, "UpdateAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAnywhereCacheOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *storageControlGRPCClient) DisableAnywhereCache(ctx context.Context, req *controlpb.DisableAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).DisableAnywhereCache[0:len((*c.CallOptions).DisableAnywhereCache):len((*c.CallOptions).DisableAnywhereCache)], opts...)
	var resp *controlpb.AnywhereCache
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.DisableAnywhereCache, req, settings.GRPC, c.logger, "DisableAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) PauseAnywhereCache(ctx context.Context, req *controlpb.PauseAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).PauseAnywhereCache[0:len((*c.CallOptions).PauseAnywhereCache):len((*c.CallOptions).PauseAnywhereCache)], opts...)
	var resp *controlpb.AnywhereCache
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.PauseAnywhereCache, req, settings.GRPC, c.logger, "PauseAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) ResumeAnywhereCache(ctx context.Context, req *controlpb.ResumeAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).ResumeAnywhereCache[0:len((*c.CallOptions).ResumeAnywhereCache):len((*c.CallOptions).ResumeAnywhereCache)], opts...)
	var resp *controlpb.AnywhereCache
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.ResumeAnywhereCache, req, settings.GRPC, c.logger, "ResumeAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) GetAnywhereCache(ctx context.Context, req *controlpb.GetAnywhereCacheRequest, opts ...gax.CallOption) (*controlpb.AnywhereCache, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>projects/[^/]+/buckets/[^/]+)(?:/.*)?"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	if req != nil && req.GetRequestId() == "" {
		req.RequestId = uuid.NewString()
	}
	opts = append((*c.CallOptions).GetAnywhereCache[0:len((*c.CallOptions).GetAnywhereCache):len((*c.CallOptions).GetAnywhereCache)], opts...)
	var resp *controlpb.AnywhereCache
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetAnywhereCache, req, settings.GRPC, c.logger, "GetAnywhereCache")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) ListAnywhereCaches(ctx context.Context, req *controlpb.ListAnywhereCachesRequest, opts ...gax.CallOption) *AnywhereCacheIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<bucket>.*)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["bucket"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAnywhereCaches[0:len((*c.CallOptions).ListAnywhereCaches):len((*c.CallOptions).ListAnywhereCaches)], opts...)
	it := &AnywhereCacheIterator{}
	req = proto.Clone(req).(*controlpb.ListAnywhereCachesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*controlpb.AnywhereCache, string, error) {
		resp := &controlpb.ListAnywhereCachesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.storageControlClient.ListAnywhereCaches, req, settings.GRPC, c.logger, "ListAnywhereCaches")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAnywhereCaches(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *storageControlGRPCClient) GetProjectIntelligenceConfig(ctx context.Context, req *controlpb.GetProjectIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetProjectIntelligenceConfig[0:len((*c.CallOptions).GetProjectIntelligenceConfig):len((*c.CallOptions).GetProjectIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetProjectIntelligenceConfig, req, settings.GRPC, c.logger, "GetProjectIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) UpdateProjectIntelligenceConfig(ctx context.Context, req *controlpb.UpdateProjectIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "intelligence_config.name", url.QueryEscape(req.GetIntelligenceConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProjectIntelligenceConfig[0:len((*c.CallOptions).UpdateProjectIntelligenceConfig):len((*c.CallOptions).UpdateProjectIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.UpdateProjectIntelligenceConfig, req, settings.GRPC, c.logger, "UpdateProjectIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) GetFolderIntelligenceConfig(ctx context.Context, req *controlpb.GetFolderIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetFolderIntelligenceConfig[0:len((*c.CallOptions).GetFolderIntelligenceConfig):len((*c.CallOptions).GetFolderIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetFolderIntelligenceConfig, req, settings.GRPC, c.logger, "GetFolderIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) UpdateFolderIntelligenceConfig(ctx context.Context, req *controlpb.UpdateFolderIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "intelligence_config.name", url.QueryEscape(req.GetIntelligenceConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateFolderIntelligenceConfig[0:len((*c.CallOptions).UpdateFolderIntelligenceConfig):len((*c.CallOptions).UpdateFolderIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.UpdateFolderIntelligenceConfig, req, settings.GRPC, c.logger, "UpdateFolderIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) GetOrganizationIntelligenceConfig(ctx context.Context, req *controlpb.GetOrganizationIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOrganizationIntelligenceConfig[0:len((*c.CallOptions).GetOrganizationIntelligenceConfig):len((*c.CallOptions).GetOrganizationIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.GetOrganizationIntelligenceConfig, req, settings.GRPC, c.logger, "GetOrganizationIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *storageControlGRPCClient) UpdateOrganizationIntelligenceConfig(ctx context.Context, req *controlpb.UpdateOrganizationIntelligenceConfigRequest, opts ...gax.CallOption) (*controlpb.IntelligenceConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "intelligence_config.name", url.QueryEscape(req.GetIntelligenceConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateOrganizationIntelligenceConfig[0:len((*c.CallOptions).UpdateOrganizationIntelligenceConfig):len((*c.CallOptions).UpdateOrganizationIntelligenceConfig)], opts...)
	var resp *controlpb.IntelligenceConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.storageControlClient.UpdateOrganizationIntelligenceConfig, req, settings.GRPC, c.logger, "UpdateOrganizationIntelligenceConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateAnywhereCacheOperation returns a new CreateAnywhereCacheOperation from a given name.
// The name must be that of a previously created CreateAnywhereCacheOperation, possibly from a different process.
func (c *storageControlGRPCClient) CreateAnywhereCacheOperation(name string) *CreateAnywhereCacheOperation {
	return &CreateAnywhereCacheOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RenameFolderOperation returns a new RenameFolderOperation from a given name.
// The name must be that of a previously created RenameFolderOperation, possibly from a different process.
func (c *storageControlGRPCClient) RenameFolderOperation(name string) *RenameFolderOperation {
	return &RenameFolderOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAnywhereCacheOperation returns a new UpdateAnywhereCacheOperation from a given name.
// The name must be that of a previously created UpdateAnywhereCacheOperation, possibly from a different process.
func (c *storageControlGRPCClient) UpdateAnywhereCacheOperation(name string) *UpdateAnywhereCacheOperation {
	return &UpdateAnywhereCacheOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
