/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int zzCY;
    int mPriority;
    long zzaxU;
    long zzaxV;
    boolean zzamB;
    long zzaxz;
    int zzaxW;
    float zzaxX;
    long zzaxY;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.zzCY = 1;
        this.mPriority = 102;
        this.zzaxU = 3600000L;
        this.zzaxV = 600000L;
        this.zzamB = false;
        this.zzaxz = Long.MAX_VALUE;
        this.zzaxW = Integer.MAX_VALUE;
        this.zzaxX = 0.0f;
        this.zzaxY = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzgu(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzaxU = millis;
        if (!this.zzamB) {
            this.zzaxV = (long)((double)this.zzaxU / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaxU;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzK(millis);
        this.zzaxY = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaxY;
        if (l < this.zzaxU) {
            l = this.zzaxU;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzamB = true;
        this.zzaxV = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaxV;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzaxz = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzaxz < 0L) {
            this.zzaxz = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzaxz = millis;
        if (this.zzaxz < 0L) {
            this.zzaxz = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaxz;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaxW = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaxW;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaxX = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaxX;
    }

    private static void zzK(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzgu(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.zzCY = versionCode;
        this.mPriority = priority;
        this.zzaxU = interval;
        this.zzaxV = fastestInterval;
        this.zzamB = explicitFastestInterval;
        this.zzaxz = expireAt;
        this.zzaxW = numUpdates;
        this.zzaxX = smallestDisplacement;
        this.zzaxY = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzgv(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzgv(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaxU + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaxV + "ms");
        if (this.zzaxY > this.zzaxU) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaxY + "ms");
        }
        if (this.zzaxz != Long.MAX_VALUE) {
            long l = this.zzaxz - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l + "ms");
        }
        if (this.zzaxW != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaxW);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzt.hashCode(this.mPriority, this.zzaxU, this.zzaxV, this.zzamB, this.zzaxz, this.zzaxW, Float.valueOf(this.zzaxX));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaxU == locationRequest.zzaxU && this.zzaxV == locationRequest.zzaxV && this.zzamB == locationRequest.zzamB && this.zzaxz == locationRequest.zzaxz && this.zzaxW == locationRequest.zzaxW && this.zzaxX == locationRequest.zzaxX;
    }

    int getVersionCode() {
        return this.zzCY;
    }
}

