/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzlk;

public final class zzkg
extends Drawable
implements Drawable.Callback {
    private int zzZo = 0;
    private long zzKT;
    private int mFrom;
    private int zzZp;
    private int zzZq = 255;
    private int zzZr;
    private int zzZs = 0;
    private boolean zzZh = true;
    private boolean zzZt;
    private zzb zzZu;
    private Drawable zzZv;
    private Drawable zzZw;
    private boolean zzZx;
    private boolean zzZy;
    private boolean zzZz;
    private int zzZA;

    public zzkg(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzZB;
        }
        this.zzZv = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzZu.zzZE |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzZB;
        }
        this.zzZw = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzZu.zzZE |= drawable3.getChangingConfigurations();
    }

    zzkg(zzb zzb2) {
        this.zzZu = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzlk.zzoR() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzlk.zzoR() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzlk.zzoR() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzZu.zzZD | this.zzZu.zzZE;
    }

    public void setAlpha(int alpha) {
        if (this.zzZs == this.zzZq) {
            this.zzZs = alpha;
        }
        this.zzZq = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzZv.setColorFilter(cf);
        this.zzZw.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzZv.getIntrinsicWidth(), this.zzZw.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzZv.getIntrinsicHeight(), this.zzZw.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzZv.setBounds(bounds);
        this.zzZw.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzZu.zzZD = this.getChangingConfigurations();
            return this.zzZu;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzZz) {
            this.zzZA = Drawable.resolveOpacity((int)this.zzZv.getOpacity(), (int)this.zzZw.getOpacity());
            this.zzZz = true;
        }
        return this.zzZA;
    }

    public boolean canConstantState() {
        if (!this.zzZx) {
            this.zzZy = this.zzZv.getConstantState() != null && this.zzZw.getConstantState() != null;
            this.zzZx = true;
        }
        return this.zzZy;
    }

    public Drawable mutate() {
        if (!this.zzZt && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzZv.mutate();
            this.zzZw.mutate();
            this.zzZt = true;
        }
        return this;
    }

    public Drawable zznp() {
        return this.zzZw;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzZp = this.zzZq;
        this.zzZs = 0;
        this.zzZr = durationMillis;
        this.zzZo = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzZo) {
            case 1: {
                this.zzKT = SystemClock.uptimeMillis();
                bl = false;
                this.zzZo = 2;
                break;
            }
            case 2: {
                if (this.zzKT < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzKT) / (float)this.zzZr;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzZo = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzZs = (int)((float)this.mFrom + (float)(this.zzZp - this.mFrom) * f);
            }
        }
        int n = this.zzZs;
        boolean bl3 = this.zzZh;
        Drawable drawable2 = this.zzZv;
        Drawable drawable3 = this.zzZw;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzZq) {
                drawable3.setAlpha(this.zzZq);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzZq - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzZq);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzZq);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzkg$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzkg$zza zzZB = new com.google.android.gms.internal.zzkg$zza();
        private static final zza zzZC = new zza();

        private com.google.android.gms.internal.zzkg$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzZC;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzZB;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzZD;
        int zzZE;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzZD = zzb2.zzZD;
                this.zzZE = zzb2.zzZE;
            }
        }

        public Drawable newDrawable() {
            return new zzkg(this);
        }

        public int getChangingConfigurations() {
            return this.zzZD;
        }
    }
}

