/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzke;

public class zzka
implements CastRemoteDisplayApi {
    private static final zzl zzQW = new zzl("CastRemoteDisplayApiImpl");
    private Api.ClientKey<zzkb> zzVu;
    private VirtualDisplay zzVv;
    private final zzke zzVw = new zzke.zza(){

        @Override
        public void zzaR(int n) {
            zzQW.zzb("onRemoteDisplayEnded", new Object[0]);
            zzka.this.zzmf();
        }
    };

    public zzka(Api.ClientKey<zzkb> clientKey) {
        this.zzVu = clientKey;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient apiClient, final String appId) {
        zzQW.zzb("startRemoteDisplay", new Object[0]);
        return apiClient.zzb(new zzb(apiClient){

            @Override
            protected void zza(zzkb zzkb2) throws RemoteException {
                zzkb2.zza(new zzb.zza(zzkb2), zzka.this.zzVw, appId);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient apiClient) {
        zzQW.zzb("stopRemoteDisplay", new Object[0]);
        return apiClient.zzb(new zzb(apiClient){

            @Override
            protected void zza(zzkb zzkb2) throws RemoteException {
                zzkb2.zza(new zzb.zzb());
            }
        });
    }

    private void zzmf() {
        if (this.zzVv != null) {
            Display display = this.zzVv.getDisplay();
            if (display != null) {
                zzQW.zzb("releasing virtual display: " + this.zzVv.getDisplay().getDisplayId(), new Object[0]);
            }
            this.zzVv.release();
            this.zzVv = null;
        }
    }

    private abstract class com.google.android.gms.internal.zzka$zzb
    extends zza.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzkb> {
        public com.google.android.gms.internal.zzka$zzb(GoogleApiClient googleApiClient) {
            super(zzka.this.zzVu, googleApiClient);
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzq(Status status) {
            return new zzc(status);
        }

        @Override
        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzq(x0);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzka$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzQW.zzb("onDisconnected", new Object[0]);
                zzka.this.zzmf();
                zzb.this.setResult(new zzc(Status.zzXP));
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzQW.zzb("onError: %d", statusCode);
                zzka.this.zzmf();
                zzb.this.setResult(new zzc(Status.zzXR));
            }
        }

        protected final class zza
        extends com.google.android.gms.internal.zzka$zza {
            private final zzkb zzVz;

            public zza(zzkb zzkb2) {
                this.zzVz = zzkb2;
            }

            private int zzi(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzQW.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzVz.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzQW.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.setResult(new zzc(Status.zzXR));
                    return;
                }
                zzka.this.zzmf();
                int n3 = this.zzi(n, n2);
                zzka.this.zzVv = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzka.this.zzVv == null) {
                    zzQW.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.setResult(new zzc(Status.zzXR));
                    return;
                }
                Display display = zzka.this.zzVv.getDisplay();
                if (display == null) {
                    zzQW.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.setResult(new zzc(Status.zzXR));
                    return;
                }
                try {
                    this.zzVz.zza(this, zzka.this.zzVv.getDisplay().getDisplayId());
                }
                catch (RemoteException remoteException) {
                    zzb.this.setResult(new zzc(Status.zzXR));
                }
            }

            @Override
            public void zzmg() {
                zzQW.zzb("onConnectedWithDisplay", new Object[0]);
                Display display = zzka.this.zzVv.getDisplay();
                if (display != null) {
                    zzb.this.setResult(new zzc(display));
                } else {
                    zzQW.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.setResult(new zzc(Status.zzXR));
                }
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzQW.zzb("onError: %d", statusCode);
                zzka.this.zzmf();
                zzb.this.setResult(new zzc(Status.zzXR));
            }
        }
    }

    private abstract class zza
    extends zzkc.zza {
        private zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int statusCode) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzmg() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzOt;
        private final Display zzRi;

        public zzc(Display display) {
            this.zzOt = Status.zzXP;
            this.zzRi = display;
        }

        public zzc(Status status) {
            this.zzOt = status;
            this.zzRi = null;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzRi;
        }
    }
}

