/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.metadata.SortableMetadataField;
import com.google.android.gms.drive.query.internal.FieldWithSortOrder;
import com.google.android.gms.drive.query.zzb;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SortOrder
implements SafeParcelable {
    public static final Parcelable.Creator<SortOrder> CREATOR = new zzb();
    final List<FieldWithSortOrder> zzahO;
    final boolean zzahP;
    final int zzCY;

    private SortOrder(List<FieldWithSortOrder> sortingFields, boolean sortFolderFirst) {
        this(1, sortingFields, sortFolderFirst);
    }

    SortOrder(int versionCode, List<FieldWithSortOrder> sortingFields, boolean sortFolderFirst) {
        this.zzCY = versionCode;
        this.zzahO = sortingFields;
        this.zzahP = sortFolderFirst;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public String toString() {
        return String.format(Locale.US, "SortOrder[%s, %s]", TextUtils.join((CharSequence)",", this.zzahO), this.zzahP);
    }

    public static class Builder {
        private final List<FieldWithSortOrder> zzahO = new ArrayList<FieldWithSortOrder>();
        private boolean zzahP = false;

        public Builder addSortAscending(SortableMetadataField sortField) {
            this.zzahO.add(new FieldWithSortOrder(sortField.getName(), true));
            return this;
        }

        public Builder addSortDescending(SortableMetadataField sortField) {
            this.zzahO.add(new FieldWithSortOrder(sortField.getName(), false));
            return this;
        }

        public SortOrder build() {
            return new SortOrder(this.zzahO, this.zzahP);
        }
    }
}

