/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.core.CoreCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;

final class GammaIntegerCodec
extends CoreCodec<Integer> {
    private final int offset;

    public GammaIntegerCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, int offset) {
        super(coreBlockInputStream, coreBlockOutputStream);
        this.offset = offset;
    }

    @Override
    public final Integer read() {
        int length = 1;
        boolean lenCodingBit = false;
        while (!this.coreBlockInputStream.readBit()) {
            ++length;
        }
        int readBits = this.coreBlockInputStream.readBits(length - 1);
        int value = readBits | 1 << length - 1;
        return value - this.offset;
    }

    @Override
    public final void write(Integer value) {
        if (value + this.offset < 1) {
            String msg = String.format("Gamma codec handles only positive values.  Value %d + Offset %d <= 0", value, this.offset);
            throw new IllegalArgumentException(msg);
        }
        long newValue = value + this.offset;
        int betaCodeLength = 1 + (int)(Math.log(newValue) / Math.log(2.0));
        if (betaCodeLength > 1) {
            this.coreBlockOutputStream.write(0L, betaCodeLength - 1);
        }
        this.coreBlockOutputStream.write(newValue, betaCodeLength);
    }

    @Override
    public Integer read(int length) {
        throw new RuntimeException("Not implemented.");
    }
}

