/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import org.eclipse.core.internal.dependencies.Element;

public class ElementChange {
    public static final int ADDED = 1;
    public static final int LINKAGE_CHANGED = 16;
    public static final int REMOVED = 2;
    public static final int RESOLVED = 4;
    public static final int UNRESOLVED = 8;
    public static final int UPDATED = 3;
    private Element element;
    private int kind;

    ElementChange(Element element, int kind) {
        this.element = element;
        this.kind = kind;
    }

    public Element getElement() {
        return this.element;
    }

    public int getKind() {
        return this.kind;
    }

    private String getStatusName(int status) {
        StringBuffer statusStr = new StringBuffer();
        if ((status & 1) != 0) {
            statusStr.append("ADDED|");
        }
        if ((status & 2) != 0) {
            statusStr.append("REMOVED|");
        }
        if ((status & 4) != 0) {
            statusStr.append("RESOLVED|");
        }
        if ((status & 8) != 0) {
            statusStr.append("UNRESOLVED|");
        }
        if ((status & 0x10) != 0) {
            statusStr.append("LINKAGE_CHANGED|");
        }
        if (statusStr.length() == 0) {
            statusStr.append("UNKNOWN");
        } else {
            statusStr.deleteCharAt(statusStr.length() - 1);
        }
        return statusStr.toString();
    }

    public Object getVersionId() {
        return this.element.getVersionId();
    }

    void setKind(int kind) {
        this.kind = kind;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.element.getId());
        result.append('_');
        result.append(this.getVersionId());
        result.append(" (");
        result.append(this.getStatusName(this.getKind()));
        result.append(')');
        return result.toString();
    }
}

