/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class JREsUpdater {
    private VMDefinitionsContainer fOriginalVMs = new VMDefinitionsContainer();
    private Shell fShell;

    public JREsUpdater(Shell shell) {
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        for (int i = 0; i < types.length; ++i) {
            IVMInstall[] vms = types[i].getVMInstalls();
            for (int j = 0; j < vms.length; ++j) {
                this.fOriginalVMs.addVM(vms[j]);
            }
        }
        this.fShell = shell;
    }

    public boolean updateJRESettings(IVMInstall[] jres, IVMInstall defaultJRE) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        for (int i = 0; i < jres.length; ++i) {
            vmContainer.addVM(jres[i]);
        }
        this.saveVMDefinitions(vmContainer);
        return true;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(JREMessages.getString("JREsUpdater.0"), 100);
                    String vmDefXML = container.getAsXML();
                    monitor.worked(40);
                    JavaRuntime.getPreferences().setValue(JavaRuntime.PREF_VM_XML, vmDefXML);
                    monitor.worked(30);
                    JavaRuntime.savePreferences();
                    monitor.worked(30);
                }
                catch (IOException ioe) {
                    JDIDebugUIPlugin.log(ioe);
                }
                catch (ParserConfigurationException e) {
                    JDIDebugUIPlugin.log(e);
                }
                catch (TransformerException e) {
                    JDIDebugUIPlugin.log(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            JDIDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    private Shell getShell() {
        if (this.fShell == null) {
            return JDIDebugUIPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }
}

