/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.PrimitiveOptionsDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class PrimitiveOptionsAction
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    static /* synthetic */ Class class$org$eclipse$debug$ui$IDebugView;

    public void init(IViewPart view) {
        this.fView = view;
        this.applyPreferences();
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        final StructuredViewer viewer = this.getStructuredViewer();
        PrimitiveOptionsDialog dialog = new PrimitiveOptionsDialog(viewer.getControl().getShell(), this.getView().getSite().getId());
        int res = dialog.open();
        if (res == 0) {
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    PrimitiveOptionsAction.this.applyPreferences();
                    viewer.refresh();
                    JDIDebugUIPlugin.getDefault().savePluginPreferences();
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IPreferenceStore getPreferenceStore() {
        return JDIDebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static boolean getPreferenceValue(String id, String preference) {
        String compositeKey = id + "." + preference;
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getView().getAdapter(class$org$eclipse$debug$ui$IDebugView == null ? (class$org$eclipse$debug$ui$IDebugView = PrimitiveOptionsAction.class$("org.eclipse.debug.ui.IDebugView")) : class$org$eclipse$debug$ui$IDebugView);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected void applyPreferences() {
        IDebugModelPresentation presentation;
        IDebugView view = (IDebugView)this.getView().getAdapter(class$org$eclipse$debug$ui$IDebugView == null ? (class$org$eclipse$debug$ui$IDebugView = PrimitiveOptionsAction.class$("org.eclipse.debug.ui.IDebugView")) : class$org$eclipse$debug$ui$IDebugView);
        if (view != null && (presentation = view.getPresentation(JDIDebugModel.getPluginIdentifier())) != null) {
            this.applyPreference(IJDIPreferencesConstants.PREF_SHOW_HEX, "SHOW_HEX_VALUES", presentation);
            this.applyPreference(IJDIPreferencesConstants.PREF_SHOW_CHAR, "SHOW_CHAR_VALUES", presentation);
            this.applyPreference(IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, "SHOW_UNSIGNED_VALUES", presentation);
        }
    }

    protected void applyPreference(String preference, String attribute, IDebugModelPresentation presentation) {
        boolean on = PrimitiveOptionsAction.getPreferenceValue(this.getView().getSite().getId(), preference);
        presentation.setAttribute(attribute, (Object)(on ? Boolean.TRUE : Boolean.FALSE));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

