/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.FragmentEntry;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.SiteReconciler;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.osgi.framework.Bundle;

public class InstallConfiguration
extends InstallConfigurationModel
implements IInstallConfiguration {
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private ListenersList listeners = new ListenersList();

    public InstallConfiguration() {
    }

    public InstallConfiguration(IInstallConfiguration config) throws MalformedURLException, CoreException {
        this(config, null, null);
    }

    public InstallConfiguration(IInstallConfiguration config, URL newLocation, String label) throws CoreException, MalformedURLException {
        IConfiguredSite[] csites;
        Date now = new Date();
        this.setCreationDate(now);
        this.setCurrent(false);
        if (newLocation == null) {
            String newFileName = UpdateManagerUtils.getLocalRandomIdentifier("platform.xml", now);
            newLocation = UpdateManagerUtils.getURL(((SiteLocal)SiteManager.getLocalSite()).getLocationURL(), newFileName, null);
        }
        this.setLocationURLString(newLocation.toExternalForm());
        if (label == null) {
            label = Utilities.format(now);
        }
        this.setLabel(label);
        if (config != null && (csites = config.getConfiguredSites()) != null) {
            for (int i = 0; i < csites.length; ++i) {
                ConfiguredSite configSite = new ConfiguredSite(csites[i]);
                this.addConfigurationSiteModel(configSite);
            }
        }
        this.resolve(newLocation, null);
        this.initialized = true;
    }

    public IConfiguredSite[] getConfiguredSites() {
        ConfiguredSiteModel[] result = this.getConfigurationSitesModel();
        if (result.length == 0) {
            return new IConfiguredSite[0];
        }
        return (IConfiguredSite[])result;
    }

    private int getDefaultPolicy() {
        return 1;
    }

    public IConfiguredSite createConfiguredSite(File file) throws CoreException {
        if (!file.getName().equals("eclipse")) {
            file = new File(file, "eclipse");
            file.mkdirs();
        }
        if (this.isDuplicateSite(file)) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.location.exists", file.getPath()), null);
        }
        BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
        ISite site = InternalSiteManager.createSite(file);
        ConfiguredSite configSite = (ConfiguredSite)factory.createConfigurationSiteModel((SiteModel)((Object)site), this.getDefaultPolicy());
        if (configSite.isNativelyLinked()) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.AlreadyNativelyLinked"), null);
        }
        if (configSite.isProductSite()) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.AlreadyProductSite"), null);
        }
        if (site != null) {
            configSite.setPlatformURLString(site.getURL().toExternalForm());
            IPlatformConfiguration runtimeConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            ConfigurationPolicy configurationPolicy = configSite.getConfigurationPolicy();
            String[] pluginPath = new String[]{};
            if (configurationPolicy.getPolicy() == 0) {
                pluginPath = configurationPolicy.getPluginPath(site);
            }
            IPlatformConfiguration.ISitePolicy sitePolicy = runtimeConfiguration.createSitePolicy(configurationPolicy.getPolicy(), pluginPath);
            IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.createSiteEntry(site.getURL(), sitePolicy);
            runtimeConfiguration.configureSite(siteEntry);
            configSite.createPrivateSiteMarker();
        }
        this.configure(configSite);
        return configSite;
    }

    public IConfiguredSite createLinkedConfiguredSite(File file) throws CoreException {
        return this.createConfiguredSite(file);
    }

    private void configure(ConfiguredSite linkedSite) throws CoreException {
        ISite site = linkedSite.getSite();
        ISiteFeatureReference[] newFeaturesRef = site.getFeatureReferences();
        for (int i = 0; i < newFeaturesRef.length; ++i) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                String reconciliationType = "enable (optimistic)";
                UpdateCore.debug("New Linked Site:New Feature: " + newFeaturesRef[i].getURL() + " as " + reconciliationType);
            }
            ConfigurationPolicy policy = linkedSite.getConfigurationPolicy();
            policy.configure(newFeaturesRef[i], true, false);
        }
        SiteReconciler.checkConfiguredFeatures(linkedSite);
    }

    public void addConfiguredSite(IConfiguredSite site) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        ConfigurationActivity activity = new ConfigurationActivity(3);
        activity.setLabel(site.getSite().getURL().toExternalForm());
        activity.setDate(new Date());
        ConfiguredSiteModel configSiteModel = (ConfiguredSiteModel)((Object)site);
        this.addConfigurationSiteModel(configSiteModel);
        configSiteModel.setInstallConfigurationModel(this);
        Object[] configurationListeners = this.listeners.getListeners();
        for (int i = 0; i < configurationListeners.length; ++i) {
            IInstallConfigurationChangedListener listener = (IInstallConfigurationChangedListener)configurationListeners[i];
            listener.installSiteAdded(site);
        }
        activity.setStatus(0);
        this.addActivity(activity);
    }

    public void addActivity(IActivity activity) {
        this.addActivityModel((ConfigurationActivityModel)((Object)activity));
    }

    public void removeConfiguredSite(IConfiguredSite site) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        if (this.removeConfigurationSiteModel((ConfiguredSiteModel)((Object)site))) {
            Object[] configurationListeners = this.listeners.getListeners();
            for (int i = 0; i < configurationListeners.length; ++i) {
                IInstallConfigurationChangedListener listener = (IInstallConfigurationChangedListener)configurationListeners[i];
                listener.installSiteRemoved(site);
            }
            ConfigurationActivity activity = new ConfigurationActivity(4);
            activity.setLabel(site.getSite().getURL().toExternalForm());
            activity.setDate(new Date());
            activity.setStatus(0);
            this.addActivity(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallConfigurationChangedListener(IInstallConfigurationChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallConfigurationChangedListener(IInstallConfigurationChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.remove(listener);
        }
    }

    public void remove() {
        if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
            File file = new File(this.getURL().getFile());
            UpdateManagerUtils.removeFromFileSystem(file);
        }
    }

    public boolean save() throws CoreException {
        int i;
        IPlatformConfiguration runtimeConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        ConfiguredSiteModel[] configurationSites = this.getConfigurationSitesModel();
        IPlatformConfiguration.IFeatureEntry[] configuredFeatureEntries = runtimeConfiguration.getConfiguredFeatureEntries();
        for (int i2 = 0; i2 < configuredFeatureEntries.length; ++i2) {
            runtimeConfiguration.unconfigureFeatureEntry(configuredFeatureEntries[i2]);
        }
        IPlatformConfiguration tempConfig = null;
        try {
            tempConfig = ConfiguratorUtils.getPlatformConfiguration(null);
            IPlatformConfiguration.ISiteEntry[] tmpSites = runtimeConfiguration.getConfiguredSites();
            for (i = 0; i < tmpSites.length; ++i) {
                tempConfig.configureSite(tmpSites[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.checkSites(configurationSites, runtimeConfiguration);
        for (int i3 = 0; i3 < configurationSites.length; ++i3) {
            ConfiguredSite cSite = (ConfiguredSite)configurationSites[i3];
            ConfigurationPolicy configurationPolicy = cSite.getConfigurationPolicy();
            this.savePluginPath(cSite, runtimeConfiguration, tempConfig);
            IFeatureReference[] configuredFeaturesRef = configurationPolicy.getConfiguredFeatures();
            for (int j = 0; j < configuredFeaturesRef.length; ++j) {
                IFeature feature = null;
                try {
                    feature = configuredFeaturesRef[j].getFeature(null);
                }
                catch (CoreException e) {
                    UpdateCore.warn(null, e);
                }
                this.saveFeatureEntry(cSite, feature, runtimeConfiguration);
            }
        }
        if (tempConfig != null) {
            IPlatformConfiguration.ISiteEntry[] tmpSites = tempConfig.getConfiguredSites();
            for (i = 0; i < tmpSites.length; ++i) {
                runtimeConfiguration.unconfigureSite(tmpSites[i]);
            }
        }
        try {
            runtimeConfiguration.save();
            this.date = new Date(runtimeConfiguration.getChangeStamp());
            if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
                UpdateCore.log(this);
            }
            this.resetActivities();
            return this.isRestartNeeded(runtimeConfiguration);
        }
        catch (IOException e) {
            CoreException exc = Utilities.newCoreException(Policy.bind("InstallConfiguration.UnableToSavePlatformConfiguration", runtimeConfiguration.getConfigurationLocation().toExternalForm()), e);
            UpdateCore.warn("", exc);
            return true;
        }
    }

    private void savePluginPath(ConfiguredSite cSite, IPlatformConfiguration runtimeConfiguration, IPlatformConfiguration tempConfig) throws CoreException {
        ConfigurationPolicy configurationPolicy = cSite.getConfigurationPolicy();
        String[] pluginPath = configurationPolicy.getPluginPath(cSite.getSite());
        IPlatformConfiguration.ISitePolicy sitePolicy = runtimeConfiguration.createSitePolicy(configurationPolicy.getPolicy(), pluginPath);
        URL urlToCheck = null;
        try {
            urlToCheck = new URL(cSite.getPlatformURLString());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.UnableToCreateURL", cSite.getPlatformURLString()), e);
        }
        catch (ClassCastException e) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.UnableToCast"), e);
        }
        IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.findConfiguredSite(urlToCheck);
        if (siteEntry == null) {
            siteEntry = runtimeConfiguration.createSiteEntry(urlToCheck, sitePolicy);
        } else {
            siteEntry.setSitePolicy(sitePolicy);
            ((SiteEntry)siteEntry).refreshPlugins();
            if (tempConfig != null) {
                tempConfig.unconfigureSite(siteEntry);
            }
        }
        ((SiteEntry)siteEntry).setEnabled(cSite.isEnabled());
        runtimeConfiguration.configureSite(siteEntry, true);
    }

    private void saveFeatureEntry(ConfiguredSite cSite, IFeature feature, IPlatformConfiguration runtimeConfiguration) throws CoreException {
        if (feature == null) {
            return;
        }
        String id = feature.getVersionedIdentifier().getIdentifier();
        IPluginEntry[] entries = feature.getPluginEntries();
        URL url = null;
        IPluginEntry featurePlugin = null;
        for (int k = 0; k < entries.length; ++k) {
            if (!id.equalsIgnoreCase(entries[k].getVersionedIdentifier().getIdentifier())) continue;
            url = this.getRuntimeConfigurationURL(entries[k], cSite);
            featurePlugin = entries[k];
            break;
        }
        String pluginVersion = null;
        if (featurePlugin != null) {
            pluginVersion = featurePlugin.getVersionedIdentifier().getVersion().toString();
        }
        if (feature.isPrimary()) {
            ArrayList<URL> list = new ArrayList<URL>();
            if (url != null) {
                list.add(url);
            }
            if (featurePlugin != null) {
                URL[] fragments = this.getRuntimeFragmentURLs(featurePlugin);
                list.addAll(Arrays.asList(fragments));
            }
            URL[] roots = list.toArray(new URL[0]);
            String pluginIdentifier = feature.getPrimaryPluginID();
            String version = feature.getVersionedIdentifier().getVersion().toString();
            String application = feature.getApplication();
            FeatureEntry featureEntry = (FeatureEntry)runtimeConfiguration.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, true, application, roots);
            featureEntry.setURL(this.getFeatureRelativeURL(feature));
            SiteEntry siteEntry = (SiteEntry)runtimeConfiguration.findConfiguredSite(cSite.getSite().getURL());
            siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)featureEntry);
        } else {
            String version = feature.getVersionedIdentifier().getVersion().toString();
            String pluginIdentifier = feature.getPrimaryPluginID();
            FeatureEntry featureEntry = (FeatureEntry)runtimeConfiguration.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, false, null, null);
            featureEntry.setURL(this.getFeatureRelativeURL(feature));
            SiteEntry siteEntry = (SiteEntry)runtimeConfiguration.findConfiguredSite(cSite.getSite().getURL());
            siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)featureEntry);
        }
        IPluginEntry[] platformPlugins = this.getPlatformPlugins(feature, runtimeConfiguration);
        for (int k = 0; k < platformPlugins.length; ++k) {
            id = platformPlugins[k].getVersionedIdentifier().getIdentifier();
            url = this.getRuntimeConfigurationURL(platformPlugins[k], cSite);
            if (url == null) continue;
            runtimeConfiguration.setBootstrapPluginLocation(id, url);
        }
    }

    private void checkSites(ConfiguredSiteModel[] configurationSites, IPlatformConfiguration runtimeConfiguration) throws CoreException {
        for (int i = 0; i < configurationSites.length; ++i) {
            URL urlToCheck = null;
            try {
                urlToCheck = new URL(configurationSites[i].getPlatformURLString());
            }
            catch (MalformedURLException e) {
                UpdateCore.warn(Policy.bind("InstallConfiguration.UnableToCreateURL", configurationSites[i].getPlatformURLString()), e);
            }
            catch (ClassCastException e) {
                UpdateCore.warn(Policy.bind("InstallConfiguration.UnableToCast"), e);
            }
            IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.findConfiguredSite(urlToCheck);
            if (siteEntry != null) continue;
            UpdateCore.warn(Policy.bind("Unable to find site {0} in platform configuration {1}.", urlToCheck.toExternalForm(), runtimeConfiguration.getConfigurationLocation().toExternalForm()));
        }
    }

    public void revertTo(IInstallConfiguration configuration, IProgressMonitor monitor, IProblemHandler handler) throws CoreException, InterruptedException {
        IConfiguredSite[] oldConfigSites = configuration.getConfiguredSites();
        IConfiguredSite[] nowConfigSites = this.getConfiguredSites();
        Hashtable<String, IConfiguredSite> oldSitesMap = new Hashtable<String, IConfiguredSite>(0);
        Hashtable<String, IConfiguredSite> newSitesMap = new Hashtable<String, IConfiguredSite>(0);
        for (int i = 0; i < oldConfigSites.length; ++i) {
            IConfiguredSite element = oldConfigSites[i];
            oldSitesMap.put(element.getSite().getURL().toExternalForm(), element);
            newSitesMap.put(element.getSite().getURL().toExternalForm(), element);
        }
        if (nowConfigSites != null) {
            String key = null;
            for (int i = 0; i < nowConfigSites.length; ++i) {
                key = nowConfigSites[i].getSite().getURL().toExternalForm();
                IConfiguredSite oldSite = (IConfiguredSite)oldSitesMap.get(key);
                if (oldSite != null) {
                    ((ConfiguredSite)nowConfigSites[i]).revertTo(oldSite, monitor, handler);
                } else {
                    ISiteFeatureReference[] featuresToUnconfigure = nowConfigSites[i].getSite().getFeatureReferences();
                    for (int j = 0; j < featuresToUnconfigure.length; ++j) {
                        IFeature featureToUnconfigure = null;
                        try {
                            featureToUnconfigure = featuresToUnconfigure[j].getFeature(null);
                        }
                        catch (CoreException e) {
                            UpdateCore.warn(null, e);
                        }
                        if (featureToUnconfigure == null) continue;
                        nowConfigSites[i].unconfigure(featureToUnconfigure);
                    }
                }
                newSitesMap.put(key, nowConfigSites[i]);
            }
            Collection sites = newSitesMap.values();
            if (sites != null && !sites.isEmpty()) {
                ConfiguredSiteModel[] sitesModel = new ConfiguredSiteModel[sites.size()];
                sites.toArray(sitesModel);
                this.setConfigurationSiteModel(sitesModel);
            }
        }
    }

    public IActivity[] getActivities() {
        if (this.getActivityModel().length == 0) {
            return new IActivity[0];
        }
        return (IActivity[])this.getActivityModel();
    }

    private IPluginEntry[] getPlatformPlugins(IFeature feature, IPlatformConfiguration runtimeConfiguration) {
        HashMap<String, IPluginEntry> featurePlatformPlugins = new HashMap<String, IPluginEntry>();
        String[] platformPluginID = runtimeConfiguration.getBootstrapPluginIdentifiers();
        IPluginEntry[] featurePlugins = feature.getPluginEntries();
        for (int i = 0; i < platformPluginID.length; ++i) {
            String featurePluginId = null;
            for (int j = 0; j < featurePlugins.length; ++j) {
                featurePluginId = featurePlugins[j].getVersionedIdentifier().getIdentifier();
                if (!platformPluginID[i].equals(featurePluginId)) continue;
                featurePlatformPlugins.put(platformPluginID[i], featurePlugins[j]);
            }
        }
        Collection values = featurePlatformPlugins.values();
        if (values == null || values.size() == 0) {
            return new IPluginEntry[0];
        }
        IPluginEntry[] result = new IPluginEntry[values.size()];
        Iterator iter = values.iterator();
        int index = 0;
        while (iter.hasNext()) {
            result[index] = (IPluginEntry)iter.next();
            ++index;
        }
        return result;
    }

    private URL getRuntimeConfigurationURL(IPluginEntry entry, ConfiguredSite cSite) throws CoreException {
        String rootString = cSite.getPlatformURLString();
        String pluginPathID = this.getPathID(entry);
        try {
            String fileString;
            ISiteContentProvider siteContentProvider = cSite.getSite().getSiteContentProvider();
            URL pluginEntryfullURL = siteContentProvider.getArchiveReference(pluginPathID);
            if (!rootString.startsWith("platform")) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                    UpdateCore.debug("getRuntimeConfiguration Plugin Entry Full URL:" + pluginEntryfullURL + " Platform String:" + rootString + " [NON PLATFORM URL].");
                }
                return pluginEntryfullURL;
            }
            URL pluginEntryRootURL = cSite.getSite().getURL();
            String relativeString = UpdateManagerUtils.getURLAsString(pluginEntryRootURL, pluginEntryfullURL);
            URL result = new URL(new URL(rootString), relativeString);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("getRuntimeConfiguration plugin Entry Full URL:" + pluginEntryfullURL + " Platform String:" + rootString + " Site URL:" + pluginEntryRootURL + " Relative:" + relativeString);
            }
            if (pluginEntryfullURL != null && "file".equals(pluginEntryfullURL.getProtocol()) && !new File(fileString = pluginEntryfullURL.getFile()).exists()) {
                UpdateCore.warn("The URL:" + result + " doesn't point to a valid platform plugin.The URL will not be written in the platform configuration", new Exception());
                return null;
            }
            return result;
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("InstallConfiguration.UnableToCreateURL", rootString), e);
        }
    }

    private URL[] getRuntimeFragmentURLs(IPluginEntry entry) throws CoreException {
        VersionedIdentifier vid = entry.getVersionedIdentifier();
        Bundle bundle = Platform.getBundle((String)vid.getIdentifier());
        ArrayList<URL> list = new ArrayList<URL>();
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 2) {
            FragmentEntry[] fragments = UpdateManagerUtils.getFragments(bundle);
            for (int i = 0; fragments != null && i < fragments.length; ++i) {
                String location = fragments[i].getLocation();
                try {
                    URL locationURL = new URL(location);
                    locationURL = Platform.asLocalURL((URL)Platform.resolve((URL)locationURL));
                    list.add(this.asInstallRelativeURL(locationURL));
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new URL[0]);
    }

    private String getPathID(IPluginEntry entry) {
        return "plugins/" + entry.getVersionedIdentifier().toString() + ".jar";
    }

    private URL asInstallRelativeURL(URL url) {
        URL install = ConfiguratorUtils.getInstallURL();
        if (install.getProtocol().equals(url.getProtocol()) && install.getProtocol().equals("file")) {
            int ix;
            String urlS;
            String installS = new File(install.getFile()).getAbsolutePath().replace(File.separatorChar, '/');
            if (!installS.endsWith("/")) {
                installS = installS + "/";
            }
            if (!(urlS = new File(url.getFile()).getAbsolutePath().replace(File.separatorChar, '/')).endsWith("/")) {
                urlS = urlS + "/";
            }
            if ((ix = installS.lastIndexOf("/")) != -1 && urlS.startsWith(installS = installS.substring(0, ix + 1))) {
                try {
                    return new URL("platform:/base/" + urlS.substring(installS.length()));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    private boolean isDuplicateSite(File siteDirectory) {
        URL fileURL;
        IConfiguredSite[] sites = this.getConfiguredSites();
        try {
            fileURL = siteDirectory.toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        for (int i = 0; i < sites.length; ++i) {
            URL url = sites[i].getSite().getURL();
            if (!UpdateManagerUtils.sameURL(fileURL, url)) continue;
            return true;
        }
        return false;
    }

    private String getFeatureRelativeURL(IFeature feature) {
        String siteURL;
        String url = feature.getURL().toExternalForm();
        if (url.startsWith(siteURL = feature.getSite().getURL().toExternalForm())) {
            return url.substring(siteURL.length());
        }
        return url;
    }

    private boolean isRestartNeeded(IPlatformConfiguration runtimeConfig) {
        URL[] newBundlePaths = runtimeConfig.getPluginPath();
        HashSet<String> newPluginsSet = new HashSet<String>(newBundlePaths.length);
        for (int i = 0; i < newBundlePaths.length; ++i) {
            String pluginLocation = newBundlePaths[i].getFile();
            newPluginsSet.add(pluginLocation);
            if (!isWindows) continue;
            newPluginsSet.add(pluginLocation.toLowerCase());
        }
        PlatformAdmin platformAdmin = Platform.getPlatformAdmin();
        State state = platformAdmin.getState();
        BundleDescription[] oldBundles = state.getBundles();
        int offset = "update@".length();
        for (int i = 0; i < oldBundles.length; ++i) {
            String oldBundleLocation;
            if (oldBundles[i].getBundleId() == 0L || !(oldBundleLocation = oldBundles[i].getLocation()).startsWith("update@") || newPluginsSet.contains(oldBundleLocation = oldBundleLocation.substring(offset)) || isWindows && newPluginsSet.contains(oldBundleLocation.toLowerCase())) continue;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Bundle " + oldBundleLocation + " has been removed");
            }
            return true;
        }
        return false;
    }

    public static void applyChanges() {
        ConfigurationActivator configurator = ConfigurationActivator.getConfigurator();
        configurator.installBundles();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstallConfiguration)) {
            return false;
        }
        InstallConfiguration config = (InstallConfiguration)obj;
        return this.getCreationDate().equals(config.getCreationDate()) && this.getLabel().equals(config.getLabel()) && this.getLocationURLString().equals(config.getLocationURLString());
    }
}

