/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.core.ConnectionThreadManager;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.UpdateCore;

public class HttpResponse
implements Response {
    private static final long POLLING_INTERVAL = 200L;
    protected URL url;
    protected InputStream in;
    protected URLConnection connection;
    protected long lastModified;
    protected long offset;

    public HttpResponse(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            this.in = this.connection.getInputStream();
            this.checkOffset();
        }
        return this.in;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            this.in = monitor != null ? this.openStreamWithCancel((HttpURLConnection)this.connection, monitor) : this.connection.getInputStream();
            this.checkOffset();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseCode();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.connection == null) {
                try {
                    this.connection = this.url.openConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.lastModified;
    }

    private InputStream openStreamWithCancel(HttpURLConnection urlConnection, IProgressMonitor monitor) throws IOException, CoreException {
        ConnectionThreadManager.StreamRunnable runnable = new ConnectionThreadManager.StreamRunnable(urlConnection);
        Thread t = UpdateCore.getPlugin().getConnectionManager().createThread(runnable);
        t.start();
        InputStream is = null;
        try {
            while (true) {
                if (monitor.isCanceled()) {
                    runnable.disconnect();
                    break;
                }
                if (runnable.getInputStream() != null) {
                    is = runnable.getInputStream();
                    break;
                }
                if (runnable.getException() != null) {
                    if (runnable.getException() instanceof IOException) {
                        throw (IOException)runnable.getException();
                    }
                    throw new CoreException((IStatus)new Status(4, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, runnable.getException().getMessage(), (Throwable)runnable.getException()));
                }
                t.join(200L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return is;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    private void checkOffset() throws IOException {
        if (this.offset == 0L) {
            return;
        }
        String range = this.connection.getHeaderField("Content-Range");
        if (range == null) {
            throw new IOException(Policy.bind("HttpResponse.rangeExpected"));
        }
        if (!range.startsWith("bytes " + this.offset + "-")) {
            throw new IOException(Policy.bind("HttpResponse.wrongRange"));
        }
    }
}

