/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.UpdateCore;

public class PluginEntry
extends PluginEntryModel
implements IPluginEntry {
    private VersionedIdentifier versionId;

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getPluginIdentifier();
        String ver = this.getPluginVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier("", null);
        return this.versionId;
    }

    public void setVersionedIdentifier(VersionedIdentifier identifier) {
        this.setPluginIdentifier(identifier.getIdentifier());
        this.setPluginVersion(identifier.getVersion().toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof IPluginEntry)) {
            return false;
        }
        IPluginEntry e = (IPluginEntry)object;
        return this.getVersionedIdentifier().equals(e.getVersionedIdentifier());
    }
}

