/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.Policy;

public class InstallMonitor
implements IProgressMonitor {
    protected IProgressMonitor monitor;
    protected Stack tasks;
    protected String taskString;
    protected String subTaskString;
    protected boolean showDetails;
    protected long totalCopyCount;
    protected long currentCount = 0L;

    protected InstallMonitor() {
    }

    public InstallMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.tasks = new Stack();
        this.taskString = "";
        this.subTaskString = "";
        this.showDetails = false;
        this.totalCopyCount = 0L;
    }

    public void beginTask(String name, int totalWork) {
        this.taskString = name;
        this.monitor.beginTask(name, totalWork);
    }

    public void done() {
        this.monitor.done();
    }

    public void internalWorked(double work) {
        this.monitor.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.taskString = name;
        this.subTaskString = "";
        this.showDetails = false;
        this.totalCopyCount = 0L;
        this.monitor.subTask("");
        this.monitor.setTaskName(name);
    }

    public void subTask(String name) {
        this.subTaskString = name;
        this.showDetails = false;
        this.totalCopyCount = 0L;
        this.monitor.subTask(name);
    }

    public void worked(int work) {
        this.monitor.worked(work);
    }

    public void saveState() {
        this.tasks.push(new MonitorState(this.taskString, this.subTaskString, this.showDetails, this.totalCopyCount));
    }

    public void restoreState() {
        if (this.tasks.size() > 0) {
            MonitorState state = (MonitorState)this.tasks.pop();
            this.setTaskName(state.getTaskString());
            this.subTask(state.getSubTaskString());
            this.showDetails = state.getShowDetails();
            this.totalCopyCount = state.getTotalCopyCount();
        }
    }

    public void showCopyDetails(boolean setting) {
        this.showDetails = setting;
    }

    public void setTotalCount(long count) {
        this.totalCopyCount = count;
    }

    public void setCopyCount(long count) {
        if (this.showDetails && count > 0L) {
            this.currentCount = count;
            long countK = count / 1024L;
            long totalK = this.totalCopyCount / 1024L;
            String msg = totalK <= 0L ? Policy.bind("InstallMonitor.DownloadSize", Long.toString(countK)) : Policy.bind("InstallMonitor.DownloadSizeLong", Long.toString(countK), Long.toString(totalK));
            this.monitor.subTask(this.subTaskString + msg);
        }
    }

    public void incrementCount(long increment) {
        this.setCopyCount(this.currentCount + increment);
    }

    protected class MonitorState {
        private String taskString;
        private String subTaskString;
        private boolean showDetails;
        private long totalCopyCount;

        private MonitorState(String taskString, String subTaskString, boolean showDetails, long totalCopyCount) {
            this.taskString = taskString;
            this.subTaskString = subTaskString;
            this.showDetails = showDetails;
            this.totalCopyCount = totalCopyCount;
        }

        private String getTaskString() {
            return this.taskString;
        }

        private String getSubTaskString() {
            return this.subTaskString;
        }

        private boolean getShowDetails() {
            return this.showDetails;
        }

        private long getTotalCopyCount() {
            return this.totalCopyCount;
        }
    }
}

