/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.update.core.IImport;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Import
extends ImportModel
implements IImport {
    private VersionedIdentifier versionId;

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getIdentifier();
        String ver = this.getVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier("", null);
        return this.versionId;
    }

    public int getRule() {
        return UpdateManagerUtils.getMatchingRule(this.getMatchingRuleName());
    }

    public int getIdRule() {
        return UpdateManagerUtils.getMatchingIdRule(this.getMatchingIdRuleName());
    }

    public int getKind() {
        return this.isFeatureImport() ? 1 : 0;
    }
}

