/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;

public class PerspectiveExtensionsTemplate
extends PDETemplateSection {
    public static final String KEY_TARGET_PERSPECTIVE = "targetPerspective";
    public static final String KEY_PERSPECTIVE_SHORTCUT = "perspectiveShortcut";
    public static final String KEY_VIEW_SHORTCUT = "viewShortcut";
    public static final String KEY_WIZARD_SHORTCUT = "wizardShortcut";
    public static final String KEY_VIEW = "view";
    public static final String KEY_VIEW_RELATIVE = "viewRelative";
    public static final String KEY_VIEW_RELATIONSHIP = "viewRelationship";
    public static final String KEY_ACTION_SET = "actionSet";
    private static final String NL_TITLE0 = "PerspectiveExtensionsTemplate.title0";
    private static final String NL_DESC0 = "PerspectiveExtensionsTemplate.desc0";
    private static final String NL_TITLE1 = "PerspectiveExtensionsTemplate.title1";
    private static final String NL_DESC1 = "PerspectiveExtensionsTemplate.desc1";
    private static final String NL_PERSPECTIVE_ID = "PerspectiveExtensionsTemplate.perspectiveId";
    private static final String NL_ACTION_SET = "PerspectiveExtensionsTemplate.actionSet";
    private static final String NL_SHORTCUT_ID = "PerspectiveExtensionsTemplate.shortcutId";
    private static final String NL_VIEW_SHORTCUT_ID = "PerspectiveExtensionsTemplate.viewShortcutId";
    private static final String NL_WIZARD_SHORTCUT_ID = "PerspectiveExtensionsTemplate.wizardShortcutId";
    private static final String NL_VIEW_ID = "PerspectiveExtensionsTemplate.viewId";
    private static final String NL_RELATIVE_VIEW = "PerspectiveExtensionsTemplate.relativeView";
    private static final String NL_RELATIVE_LOCATION = "PerspectiveExtensionsTemplate.relativePosition";
    private static final String NL_STACK = "PerspectiveExtensionsTemplate.stack";
    private static final String NL_FAST = "PerspectiveExtensionsTemplate.fast";
    private static final String NL_LEFT = "PerspectiveExtensionsTemplate.left";
    private static final String NL_RIGHT = "PerspectiveExtensionsTemplate.right";
    private static final String NL_TOP = "PerspectiveExtensionsTemplate.top";
    private static final String NL_BOTTOM = "PerspectiveExtensionsTemplate.buttom";

    public PerspectiveExtensionsTemplate() {
        this.setPageCount(2);
        this.createOptions();
    }

    public void addPages(Wizard wizard) {
        WizardPage page0 = this.createPage(0, "org.eclipse.pde.doc.user.template_perspective_extensions");
        page0.setTitle(PDEPlugin.getResourceString(NL_TITLE0));
        page0.setDescription(PDEPlugin.getResourceString(NL_DESC0));
        wizard.addPage((IWizardPage)page0);
        WizardPage page1 = this.createPage(1, "org.eclipse.pde.doc.user.template_perspective_extensions");
        page1.setTitle(PDEPlugin.getResourceString(NL_TITLE1));
        page1.setDescription(PDEPlugin.getResourceString(NL_DESC1));
        wizard.addPage((IWizardPage)page1);
        this.markPagesAdded();
    }

    private void createOptions() {
        this.addOption(KEY_TARGET_PERSPECTIVE, PDEPlugin.getResourceString(NL_PERSPECTIVE_ID), "org.eclipse.ui.resourcePerspective", 0);
        this.addOption(KEY_ACTION_SET, PDEPlugin.getResourceString(NL_ACTION_SET), "org.eclipse.jdt.ui.JavaActionSet", 0);
        this.addOption(KEY_PERSPECTIVE_SHORTCUT, PDEPlugin.getResourceString(NL_SHORTCUT_ID), "org.eclipse.debug.ui.DebugPerspective", 0);
        this.addOption(KEY_VIEW_SHORTCUT, PDEPlugin.getResourceString(NL_VIEW_SHORTCUT_ID), "org.eclipse.jdt.ui.TypeHierarchy", 0);
        this.addOption(KEY_WIZARD_SHORTCUT, PDEPlugin.getResourceString(NL_WIZARD_SHORTCUT_ID), "org.eclipse.jdt.ui.wizards.NewProjectCreationWizard", 0);
        this.addOption(KEY_VIEW, PDEPlugin.getResourceString(NL_VIEW_ID), "org.eclipse.jdt.ui.PackageExplorer", 1);
        this.addOption(KEY_VIEW_RELATIVE, PDEPlugin.getResourceString(NL_RELATIVE_VIEW), "org.eclipse.ui.views.ResourceNavigator", 1);
        this.addOption(KEY_VIEW_RELATIONSHIP, PDEPlugin.getResourceString(NL_RELATIVE_LOCATION), new String[][]{{"stack", PDEPlugin.getResourceString(NL_STACK)}, {"fast", PDEPlugin.getResourceString(NL_FAST)}, {"left", PDEPlugin.getResourceString(NL_LEFT)}, {"right", PDEPlugin.getResourceString(NL_RIGHT)}, {"top", PDEPlugin.getResourceString(NL_TOP)}, {"bottom", PDEPlugin.getResourceString(NL_BOTTOM)}}, "stack", 1);
    }

    private TemplateOption[] getAllPageOptions(TemplateOption source) {
        int pageIndex = this.getPageIndex(source);
        if (pageIndex != -1) {
            return this.getOptions(pageIndex);
        }
        return new TemplateOption[0];
    }

    public String getSectionId() {
        return "perspectiveExtensions";
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] siblings = this.getAllPageOptions(source);
        for (int i = 0; i < siblings.length; ++i) {
            TemplateOption nextOption = siblings[i];
            if (!nextOption.isRequired() || !nextOption.isEmpty()) continue;
            this.flagMissingRequiredOption(nextOption);
            return;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement perspectiveElement = factory.createElement((IPluginObject)extension);
        perspectiveElement.setName("perspectiveExtension");
        perspectiveElement.setAttribute("targetID", this.getStringOption(KEY_TARGET_PERSPECTIVE));
        IPluginElement wizardShortcutElement = factory.createElement((IPluginObject)perspectiveElement);
        wizardShortcutElement.setName("newWizardShortcut");
        wizardShortcutElement.setAttribute("id", this.getStringOption(KEY_WIZARD_SHORTCUT));
        perspectiveElement.add((IPluginObject)wizardShortcutElement);
        IPluginElement viewShortcutElement = factory.createElement((IPluginObject)perspectiveElement);
        viewShortcutElement.setName(KEY_VIEW_SHORTCUT);
        viewShortcutElement.setAttribute("id", this.getStringOption(KEY_VIEW_SHORTCUT));
        perspectiveElement.add((IPluginObject)viewShortcutElement);
        IPluginElement perspectiveShortcutElement = factory.createElement((IPluginObject)perspectiveElement);
        perspectiveShortcutElement.setName(KEY_PERSPECTIVE_SHORTCUT);
        perspectiveShortcutElement.setAttribute("id", this.getStringOption(KEY_PERSPECTIVE_SHORTCUT));
        perspectiveElement.add((IPluginObject)perspectiveShortcutElement);
        IPluginElement actionSetElement = factory.createElement((IPluginObject)perspectiveElement);
        actionSetElement.setName(KEY_ACTION_SET);
        actionSetElement.setAttribute("id", this.getStringOption(KEY_ACTION_SET));
        perspectiveElement.add((IPluginObject)actionSetElement);
        IPluginElement viewElement = factory.createElement((IPluginObject)perspectiveElement);
        viewElement.setName(KEY_VIEW);
        viewElement.setAttribute("id", this.getStringOption(KEY_VIEW));
        viewElement.setAttribute("relative", this.getStringOption(KEY_VIEW_RELATIVE));
        String relationship = this.getValue(KEY_VIEW_RELATIONSHIP).toString();
        viewElement.setAttribute("relationship", relationship);
        if (!relationship.equals("stack") && !relationship.equals("fast")) {
            viewElement.setAttribute("ratio", "0.5");
        }
        perspectiveElement.add((IPluginObject)viewElement);
        extension.add((IPluginObject)perspectiveElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.perspectiveExtensions";
    }
}

