/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardFirstPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class FeatureImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "FeatureImportWizard";
    private static final String KEY_MESSAGES_TITLE = "FeatureImportWizard.messages.title";
    private FeatureImportWizardFirstPage fPage1;
    private FeatureImportWizardDetailedPage fPage2;

    public FeatureImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_IMPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString("FeatureImportWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.fPage1 = new FeatureImportWizardFirstPage();
        this.addPage((IWizardPage)this.fPage1);
        this.fPage2 = new FeatureImportWizardDetailedPage(this.fPage1);
        this.addPage((IWizardPage)this.fPage2);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        try {
            IFeatureModel[] models = this.fPage2.getSelectedModels();
            this.fPage1.storeSettings(true);
            IPath targetPath = this.computeTargetPath();
            IRunnableWithProgress op = FeatureImportWizard.getImportOperation(this.getShell(), models, targetPath);
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return true;
        }
        return true;
    }

    private IPath computeTargetPath() {
        IPath pluginsLocation = PDEPlugin.getWorkspace().getRoot().getLocation();
        return pluginsLocation.removeLastSegments(1).append("features");
    }

    public static IRunnableWithProgress getImportOperation(final Shell shell, final IFeatureModel[] models, final IPath targetPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ReplaceQuery query = new ReplaceQuery(shell);
                    FeatureImportOperation op = new FeatureImportOperation(models, targetPath, query);
                    PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private static class ReplaceQuery
    implements FeatureImportOperation.IReplaceQuery {
        private Shell shell;
        private int yesToAll = 0;
        private int[] RETURNCODES = new int[]{2, 2, 1, 1, 0};

        public ReplaceQuery(Shell shell) {
            this.shell = shell;
        }

        public int doQuery(IProject project) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            String message = PDEPlugin.getFormattedMessage("FeatureImportWizard.messages.exists", project.getName());
            int[] result = new int[]{0};
            this.shell.getDisplay().syncExec(new Runnable(this, message, result){
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                private final /* synthetic */ ReplaceQuery this$0;
                {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                    this.val$result = val$result;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(ReplaceQuery.access$000(this.this$0), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ReplaceQuery.access$100(this.this$0)[retVal];
                        if (retVal == 1) {
                            ReplaceQuery.access$202(this.this$0, 1);
                        } else if (retVal == 3) {
                            ReplaceQuery.access$202(this.this$0, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ Shell access$000(ReplaceQuery x0) {
            return x0.shell;
        }

        static /* synthetic */ int[] access$100(ReplaceQuery x0) {
            return x0.RETURNCODES;
        }

        static /* synthetic */ int access$202(ReplaceQuery x0, int x1) {
            x0.yesToAll = x1;
            return x0.yesToAll;
        }
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEPlugin.getResourceString(FeatureImportWizard.KEY_MESSAGES_TITLE), null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEPlugin.getResourceString("FeatureImportWizard.noToAll"), IDialogConstants.CANCEL_LABEL}, 0);
        }
    }
}

