/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FeatureExportJob
extends Job
implements IPreferenceConstants {
    public static final int EXPORT_AS_ZIP = 0;
    public static final int EXPORT_AS_DIRECTORY = 1;
    public static final int EXPORT_AS_UPDATE_JARS = 2;
    protected static PrintWriter writer;
    protected static File logFile;
    protected int fExportType;
    protected boolean fExportSource;
    protected String fDestinationDirectory;
    protected String fZipFilename;
    protected Object[] fItems;
    protected String fBuildTempLocation;
    private String fDevProperties;
    protected HashMap fBuildProperties;

    public FeatureExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(PDEPlugin.getResourceString("FeatureExportJob.name"));
        this.fExportType = exportType;
        this.fExportSource = exportSource;
        this.fDestinationDirectory = destination;
        this.fZipFilename = zipFileName;
        this.fItems = items;
        this.fBuildTempLocation = PDEPlugin.getDefault().getStateLocation().append("temp").toString();
        this.setRule(new SchedulingRule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage = null;
        try {
            FeatureExportJob.createLogWriter();
            this.doExports(monitor);
        }
        catch (CoreException e) {
            final Display display = FeatureExportJob.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)PDEPlugin.getResourceString("FeatureExportJob.error"), (String)PDEPlugin.getResourceString("FeatureExportJob.problems"), (IStatus)e.getStatus());
                    FeatureExportJob.this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
                }
            });
            IStatus iStatus = Job.ASYNC_FINISH;
            Object var7_4 = null;
            if (writer != null) {
                writer.close();
            }
            return iStatus;
        }
        catch (InvocationTargetException e) {
            try {
                String message = e.getTargetException().getMessage();
                if (message != null && message.length() > 0) {
                    errorMessage = e.getTargetException().getMessage();
                }
                Object var7_5 = null;
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
        }
        Object var7_3 = null;
        if (writer != null) {
            writer.close();
        }
        if (errorMessage == null && logFile != null && logFile.exists() && logFile.length() > 0L) {
            errorMessage = this.getLogFoundMessage();
        }
        if (errorMessage != null) {
            final String em = errorMessage;
            FeatureExportJob.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    FeatureExportJob.this.asyncNotifyExportException(em);
                }
            });
            return Job.ASYNC_FINISH;
        }
        return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExports(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        this.createDestination();
        monitor.beginTask("", this.fItems.length + 1);
        try {
            for (int i = 0; i < this.fItems.length; ++i) {
                IFeatureModel model = (IFeatureModel)this.fItems[i];
                try {
                    IFeature feature = model.getFeature();
                    String id = feature.getId();
                    String os = this.getOS(feature);
                    String ws = this.getWS(feature);
                    String arch = this.getOSArch(feature);
                    this.doExport(id, model.getFeature().getVersion(), model.getInstallLocation(), os, ws, arch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                finally {
                    this.deleteBuildFiles((IModel)model);
                }
            }
        }
        finally {
            this.cleanup((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.done();
        }
    }

    private String getOS(IFeature feature) {
        String os = feature.getOS();
        if (os == null || os.trim().length() == 0 || os.indexOf(44) != -1 || os.equals("*")) {
            return TargetPlatform.getOS();
        }
        return os;
    }

    private String getWS(IFeature feature) {
        String ws = feature.getWS();
        if (ws == null || ws.trim().length() == 0 || ws.indexOf(44) != -1 || ws.equals("*")) {
            return TargetPlatform.getWS();
        }
        return ws;
    }

    private String getOSArch(IFeature feature) {
        String arch = feature.getArch();
        if (arch == null || arch.trim().length() == 0 || arch.indexOf(44) != -1 || arch.equals("*")) {
            return TargetPlatform.getOSArch();
        }
        return arch;
    }

    private void createDestination() throws InvocationTargetException {
        File file = new File(this.fDestinationDirectory);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDEPlugin.getResourceString("ExportWizard.badDirectory")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(String featureID, String version, String featureLocation, String os, String ws, String arch, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask("", 5);
        monitor.setTaskName(PDEPlugin.getResourceString("FeatureExportJob.taskName"));
        try {
            HashMap properties = this.createBuildProperties(os, ws, arch);
            this.makeScript(featureID, version, os, ws, arch, featureLocation);
            monitor.worked(1);
            this.runScript(this.getBuildScriptName(featureLocation), this.getBuildExecutionTargets(), properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.runScript(this.getAssemblyScriptName(featureID, os, ws, arch, featureLocation), new String[]{"main"}, properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    protected HashMap createBuildProperties(String os, String ws, String arch) {
        if (this.fBuildProperties == null) {
            this.fBuildProperties = new HashMap(15);
            this.fBuildProperties.put("buildTempFolder", this.fBuildTempLocation + "/destination");
            this.fBuildProperties.put("temp.folder", this.fBuildTempLocation + "/temp.folder");
            this.fBuildProperties.put("feature.temp.folder", this.fBuildTempLocation + "/destination");
            this.fBuildProperties.put("include.children", "true");
            this.fBuildProperties.put("eclipse.running", "true");
            this.fBuildProperties.put("baseos", os);
            this.fBuildProperties.put("basews", ws);
            this.fBuildProperties.put("basearch", arch);
            this.fBuildProperties.put("basenl", TargetPlatform.getNL());
            this.fBuildProperties.put("bootclasspath", BaseBuildAction.getBootClasspath());
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            this.fBuildProperties.put("javacFailOnError", "false");
            this.fBuildProperties.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
            this.fBuildProperties.put("javacVerbose", store.getString("javacVerbose"));
            Preferences pref = JavaCore.getPlugin().getPluginPreferences();
            this.fBuildProperties.put("javacSource", pref.getString("org.eclipse.jdt.core.compiler.source"));
            this.fBuildProperties.put("javacTarget", pref.getString("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
            this.fBuildProperties.put("buildDirectory", this.fBuildTempLocation + "/assemblyLocation");
            this.fBuildProperties.put("buildLabel", ".");
            this.fBuildProperties.put("collectingFolder", ".");
            String prefix = Platform.getOS().equals("macosx") ? "." : "";
            this.fBuildProperties.put("archivePrefix", prefix);
            if (this.fExportType == 0) {
                this.fBuildProperties.put("archiveFullPath", this.fDestinationDirectory + File.separator + this.fZipFilename);
            } else {
                this.fBuildProperties.put("assemblyTempDir", this.fDestinationDirectory);
            }
        }
        return this.fBuildProperties;
    }

    private void makeScript(String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        BuildScriptGenerator generator = new BuildScriptGenerator();
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        generator.setChildren(true);
        generator.setWorkingDirectory(featureLocation);
        generator.setDevEntries(this.getDevProperties());
        generator.setElements(new String[]{"feature@" + featureID + (versionId == null ? "" : ":" + versionId)});
        generator.setPluginPath(this.getPaths());
        String format = this.fExportType == 0 ? (Platform.getOS().equals("macosx") ? "tarGz" : "antZip") : "folder";
        BuildScriptGenerator.setOutputFormat((String)format);
        BuildScriptGenerator.setForceUpdateJar((this.fExportType == 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setEmbeddedSource((this.fExportSource && this.fExportType != 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setConfigInfo((String)(os + "," + ws + "," + arch));
        generator.generate();
    }

    private String getDevProperties() {
        if (this.fDevProperties == null) {
            this.fDevProperties = ClasspathHelper.getDevEntriesProperties(this.fBuildTempLocation + "/dev.properties", false);
        }
        return this.fDevProperties;
    }

    protected void runScript(String location, String[] targets, Map properties, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AntRunner runner = new AntRunner();
        runner.addUserProperties(properties);
        runner.setAntHome(location);
        runner.setBuildFileLocation(location);
        runner.addBuildListener("org.eclipse.pde.internal.ui.ant.ExportBuildListener");
        runner.setExecutionTargets(targets);
        runner.run(monitor);
    }

    private String getBuildScriptName(String featureLocation) {
        return featureLocation + '/' + "build.xml";
    }

    protected String getAssemblyScriptName(String featureID, String os, String ws, String arch, String featureLocation) {
        return featureLocation + '/' + "assemble." + featureID + "." + os + "." + ws + "." + arch + ".xml";
    }

    private String[] getBuildExecutionTargets() {
        if (this.fExportSource && this.fExportType != 2) {
            return new String[]{"build.jars", "build.sources", "gather.logs"};
        }
        return new String[]{"build.jars", "gather.logs"};
    }

    public void deleteBuildFiles(IModel model) throws CoreException {
        int i;
        File dir;
        Object[] children;
        String directory;
        if (model == null) {
            return;
        }
        String string = directory = model instanceof IFeatureModel ? ((IFeatureModel)model).getInstallLocation() : ((IPluginModelBase)model).getInstallLocation();
        if (model.getUnderlyingResource() != null && !this.isCustomBuild(model) && (children = (dir = new File(directory)).listFiles()) != null) {
            for (i = 0; i < children.length; ++i) {
                String filename;
                if (children[i].isDirectory() || !(filename = children[i].getName()).equals("build.xml") && (!filename.startsWith("assemble.") || !filename.endsWith(".xml"))) continue;
                children[i].delete();
            }
        }
        if (model instanceof IFeatureModel) {
            IFeature feature = ((IFeatureModel)model).getFeature();
            children = feature.getIncludedFeatures();
            for (i = 0; i < children.length; ++i) {
                IFeature ref = ((FeatureChild)children[i]).getReferencedFeature();
                if (ref == null) continue;
                this.deleteBuildFiles((IModel)ref.getModel());
            }
            IFeaturePlugin[] plugins = feature.getPlugins();
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                ModelEntry entry = manager.findEntry(plugins[i2].getId());
                if (entry == null) continue;
                this.deleteBuildFiles((IModel)entry.getActiveModel());
            }
        }
    }

    protected boolean isCustomBuild(IModel model) throws CoreException {
        IBuild build;
        IBuildEntry entry;
        WorkspaceBuildModel buildModel = null;
        IFile buildFile = model.getUnderlyingResource().getProject().getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null && (entry = (build = buildModel.getBuild()).getEntry("custom")) != null) {
            String[] tokens = entry.getTokens();
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].equals("true")) continue;
                return true;
            }
        }
        return false;
    }

    protected String[] getPaths() throws CoreException {
        ArrayList<String> paths = new ArrayList<String>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        for (int i = 0; i < models.length; ++i) {
            paths.add(models[i].getInstallLocation() + '/' + "feature.xml");
        }
        String[] plugins = TargetPlatform.createPluginPath();
        String[] features = paths.toArray(new String[paths.size()]);
        String[] all = new String[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        return all;
    }

    private static void createLogWriter() {
        try {
            String path = PDEPlugin.getDefault().getStateLocation().toOSString();
            logFile = new File(path, "exportLog.txt");
            if (logFile.exists()) {
                logFile.delete();
                logFile.createNewFile();
            }
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PrintWriter getWriter() {
        if (writer == null) {
            FeatureExportJob.createLogWriter();
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cleanup(IProgressMonitor monitor) {
        File scriptFile = null;
        try {
            try {
                scriptFile = this.createScriptFile();
                writer = new PrintWriter((Writer)new FileWriter(scriptFile), true);
                this.generateHeader(writer);
                this.generateDeleteZipTarget(writer);
                this.generateCleanTarget(writer);
                boolean errors = this.generateZipLogsTarget(writer);
                this.generateClosingTag(writer);
                writer.close();
                ArrayList<String> targets = new ArrayList<String>();
                targets.add("deleteZip");
                if (errors) {
                    targets.add("zip.logs");
                }
                targets.add("clean");
                AntRunner runner = new AntRunner();
                runner.setBuildFileLocation(scriptFile.getAbsolutePath());
                runner.setExecutionTargets(targets.toArray(new String[targets.size()]));
                runner.run(monitor);
            }
            catch (IOException e) {
                Object var7_9 = null;
                if (scriptFile == null) return;
                if (!scriptFile.exists()) return;
                scriptFile.delete();
                return;
            }
            catch (CoreException coreException) {
                Object var7_10 = null;
                if (scriptFile == null) return;
                if (!scriptFile.exists()) return;
                scriptFile.delete();
                return;
            }
            Object var7_8 = null;
            if (scriptFile == null) return;
            if (!scriptFile.exists()) return;
            scriptFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (scriptFile == null) throw throwable;
            if (!scriptFile.exists()) throw throwable;
            scriptFile.delete();
            throw throwable;
        }
    }

    private File createScriptFile() throws IOException {
        String path = PDEPlugin.getDefault().getStateLocation().toOSString();
        File zip = new File(path, "zip.xml");
        if (zip.exists()) {
            zip.delete();
            zip.createNewFile();
        }
        return zip;
    }

    private void generateHeader(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project name=\"temp\" default=\"clean\" basedir=\".\">");
    }

    private void generateCleanTarget(PrintWriter writer) {
        writer.println("<target name=\"clean\">");
        writer.println("<delete dir=\"" + this.fBuildTempLocation + "\"/>");
        writer.println("</target>");
    }

    private void generateDeleteZipTarget(PrintWriter writer) {
        writer.println("<target name=\"deleteZip\">");
        writer.println("<delete file=\"" + this.fDestinationDirectory + "/logs.zip\"/>");
        writer.println("</target>");
    }

    private boolean generateZipLogsTarget(PrintWriter writer) {
        if (logFile != null && logFile.exists() && logFile.length() > 0L) {
            writer.println("<target name=\"zip.logs\">");
            writer.println("<zip zipfile=\"" + this.fDestinationDirectory + "/logs.zip\" basedir=\"" + this.fBuildTempLocation + "/temp.folder\"/>");
            writer.println("</target>");
            return true;
        }
        return false;
    }

    private void generateClosingTag(PrintWriter writer) {
        writer.println("</project>");
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        FeatureExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("FeatureExportJob.error"), (String)errorMessage);
        this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
    }

    protected String getLogFoundMessage() {
        return PDEPlugin.getFormattedMessage("ExportJob.error.message", this.fDestinationDirectory + File.separator + "logs.zip");
    }

    class SchedulingRule
    implements ISchedulingRule {
        SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }
    }
}

