/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.DependencyExtentLabelProvider;
import org.eclipse.pde.internal.ui.search.DependencyExtentSearchOperation;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.ReferencesInPluginAction;
import org.eclipse.pde.internal.ui.search.SearchGoToAction;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class DependencyExtentSearchResultCollector {
    private static final String PAGE_ID = "org.eclipse.pde.internal.ui.search.dependencyExtent";
    private static final String KEY_DEPENDENCY = "DependencyExtent.singular";
    private static final String KEY_DEPENDENCIES = "DependencyExtent.plural";
    private static final String KEY_FOUND = "DependencyExtent.found";
    private static final String KEY_SEARCHING = "DependencyExtent.searching";
    private int numMatches = 0;
    private ISearchResultView resultView;
    private IProgressMonitor monitor;
    private DependencyExtentSearchOperation operation;

    public DependencyExtentSearchResultCollector(DependencyExtentSearchOperation op, IProgressMonitor monitor) {
        this.operation = op;
        this.monitor = monitor;
    }

    public void accept(Object match) {
        try {
            IProject resource = this.operation.getProject();
            IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
            if (match instanceof IPluginExtensionPoint) {
                if (match instanceof ISourceObject) {
                    marker.setAttribute("lineNumber", ((ISourceObject)match).getStartLine());
                }
                if (((IPluginExtensionPoint)match).getModel().getUnderlyingResource() == null) {
                    this.annotateExternalMarker(marker, (IPluginObject)((IPluginExtensionPoint)match));
                }
            }
            this.resultView.addMatch(null, match, (IResource)resource, marker);
            ++this.numMatches;
            String text = this.numMatches > 1 ? PDEPlugin.getResourceString(KEY_DEPENDENCIES) : PDEPlugin.getResourceString(KEY_DEPENDENCY);
            this.monitor.setTaskName(PDEPlugin.getResourceString(KEY_SEARCHING) + " " + this.numMatches + " " + text + " " + PDEPlugin.getResourceString(KEY_FOUND));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void done() {
        if (this.resultView != null) {
            this.resultView.searchFinished();
        }
    }

    private void annotateExternalMarker(IMarker marker, IPluginObject match) throws CoreException {
        IPluginModelBase model = match.getPluginModel();
        String path = model.getInstallLocation();
        String manifest = model.isFragmentModel() ? "fragment.xml" : "plugin.xml";
        String fileName = path + File.separator + manifest;
        marker.setAttribute("org.eclipse.pde.ui.systemFilePath", (Object)fileName);
    }

    public void searchStarted() {
        this.resultView = SearchUI.getSearchResultView();
        this.resultView.searchStarted((IActionGroupFactory)new SearchActionGroupFactory(), this.operation.getSingularLabel(), this.operation.getPluralLabel(), null, PAGE_ID, (ILabelProvider)new DependencyExtentLabelProvider(), (IAction)new SearchGoToAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.operation);
    }

    class SearchActionGroup
    extends PluginSearchActionGroup {
        SearchActionGroup() {
        }

        public void fillContextMenu(IMenuManager menu) {
            super.fillContextMenu(menu);
            ActionContext context = this.getContext();
            IStructuredSelection selection = (IStructuredSelection)context.getSelection();
            if (selection.size() == 1) {
                ISearchResultViewEntry entry = (ISearchResultViewEntry)selection.getFirstElement();
                menu.add((IAction)new ReferencesInPluginAction(entry));
            }
        }
    }

    class SearchActionGroupFactory
    implements IActionGroupFactory {
        SearchActionGroupFactory() {
        }

        public ActionGroup createActionGroup(ISearchResultView searchView) {
            return new SearchActionGroup();
        }
    }

    class GroupByKeyComputer
    implements IGroupByKeyComputer {
        GroupByKeyComputer() {
        }

        public Object computeGroupByKey(IMarker marker) {
            return marker;
        }
    }
}

