/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CompilersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IEnvironmentVariables {
    private ArrayList fFlagControls;
    private HashSet fChangedControls = new HashSet();
    private Composite fPluginPage;
    private Composite fSchemaPage;
    private Composite fFeaturePage;
    private HashSet fBuilders = new HashSet();

    public CompilersPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString("CompilersPreferencePage.desc"));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(container, 0);
        GridData gd = new GridData(1808);
        folder.setLayoutData((Object)gd);
        this.fFlagControls = new ArrayList();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilersPreferencePage.this.addChangedConrol((Control)e.widget);
            }
        };
        ModifyListener mlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilersPreferencePage.this.addChangedConrol((Control)e.widget);
            }
        };
        String[] choices = new String[]{PDEPlugin.getResourceString("CompilersPreferencePage.error"), PDEPlugin.getResourceString("CompilersPreferencePage.warning"), PDEPlugin.getResourceString("CompilersPreferencePage.ignore")};
        this.fPluginPage = this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.plugins"), 0, choices);
        this.fSchemaPage = this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.schemas"), 1, choices);
        this.fFeaturePage = this.createPage(folder, PDEPlugin.getResourceString("CompilersPreferencePage.features"), 2, choices);
        for (int i = 0; i < this.fFlagControls.size(); ++i) {
            Control control = (Control)this.fFlagControls.get(i);
            if (control instanceof Combo) {
                ((Combo)control).addSelectionListener((SelectionListener)listener);
                continue;
            }
            if (control instanceof Button) {
                ((Button)control).addSelectionListener((SelectionListener)listener);
                continue;
            }
            if (!(control instanceof Text)) continue;
            ((Text)control).addModifyListener(mlistener);
        }
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.compilers_preference_page");
        return container;
    }

    private void addChangedConrol(Control control) {
        String flagId = (String)control.getData();
        boolean doAdd = false;
        if (control instanceof Combo) {
            int oldIndex;
            int newIndex = ((Combo)control).getSelectionIndex();
            doAdd = newIndex != (oldIndex = CompilerFlags.getFlag((String)flagId));
        } else if (control instanceof Button) {
            boolean newValue = ((Button)control).getSelection();
            boolean oldValue = CompilerFlags.getBoolean((String)flagId);
            doAdd = oldValue != newValue;
        } else if (control instanceof Text) {
            String oldValue;
            String newValue = ((Text)control).getText();
            boolean bl = doAdd = !newValue.equals(oldValue = CompilerFlags.getString((String)flagId));
        }
        if (doAdd) {
            this.fChangedControls.add(control);
        } else if (this.fChangedControls.contains(control)) {
            this.fChangedControls.remove(control);
        }
    }

    private Composite createPage(TabFolder folder, String name, int index, String[] choices) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(name);
        tab.setControl((Control)page);
        Label label = new Label(page, 0);
        String textKey = index == 1 ? "CompilersPreferencePage.altlabel" : "CompilersPreferencePage.label";
        label.setText(PDEPlugin.getResourceString(textKey));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] flagIds = CompilerFlags.getFlags((int)index);
        for (int i = 0; i < flagIds.length; ++i) {
            Control control = this.createFlag(page, flagIds[i], choices);
            this.fFlagControls.add(control);
        }
        return page;
    }

    private Control createFlag(Composite page, String flagId, String[] choices) {
        Combo control = null;
        if (CompilerFlags.getFlagType((String)flagId) == 0) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Combo combo = new Combo(page, 8);
            combo.setItems(choices);
            combo.select(CompilerFlags.getFlag((String)flagId));
            control = combo;
        } else if (CompilerFlags.getFlagType((String)flagId) == 1) {
            Button button = new Button(page, 32);
            button.setText(PDEPlugin.getResourceString(flagId));
            button.setSelection(CompilerFlags.getBoolean((String)flagId));
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            button.setLayoutData((Object)gd);
            control = button;
        } else if (CompilerFlags.getFlagType((String)flagId) == 2) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Text text = new Text(page, 2052);
            text.setText(CompilerFlags.getString((String)flagId));
            GridData gd = new GridData(768);
            gd.widthHint = 50;
            text.setLayoutData((Object)gd);
            new Label(page, 0).setLayoutData((Object)new GridData());
            GridData sgd = new GridData();
            Label slabel = new Label(page, 0);
            slabel.setText(PDEPlugin.getResourceString("CompilersPreferencePage.label"));
            sgd.horizontalSpan = 2;
            slabel.setLayoutData((Object)sgd);
            control = text;
        }
        control.setData((Object)flagId);
        return control;
    }

    protected void performDefaults() {
        this.fChangedControls.clear();
        for (int i = 0; i < this.fFlagControls.size(); ++i) {
            boolean hasChange = false;
            Control control = (Control)this.fFlagControls.get(i);
            String flagId = (String)control.getData();
            if (control instanceof Combo) {
                hasChange = ((Combo)control).getSelectionIndex() != CompilerFlags.getDefaultFlag((String)flagId);
                ((Combo)control).select(CompilerFlags.getDefaultFlag((String)flagId));
            } else if (control instanceof Button) {
                hasChange = ((Button)control).getSelection() != CompilerFlags.getDefaultBoolean((String)flagId);
                ((Button)control).setSelection(CompilerFlags.getDefaultBoolean((String)flagId));
            } else if (control instanceof Text) {
                hasChange = ((Text)control).getText() != CompilerFlags.getDefaultString((String)flagId);
                ((Text)control).setText(CompilerFlags.getDefaultString((String)flagId));
            }
            if (!hasChange) continue;
            this.fChangedControls.add(control);
        }
    }

    public boolean performOk() {
        if (this.fChangedControls.size() > 0) {
            String title = PDEPlugin.getResourceString("CompilersPreferencePage.rebuild.title");
            String message = PDEPlugin.getResourceString("CompilersPreferencePage.rebuild.message");
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 2) {
                return false;
            }
            this.fBuilders = new HashSet();
            Iterator iter = this.fChangedControls.iterator();
            while (iter.hasNext()) {
                Control control = (Control)iter.next();
                String flagId = (String)control.getData();
                if (control instanceof Combo) {
                    int index = ((Combo)control).getSelectionIndex();
                    CompilerFlags.setFlag((String)flagId, (int)index);
                } else if (control instanceof Button) {
                    boolean value = ((Button)control).getSelection();
                    CompilerFlags.setBoolean((String)flagId, (boolean)value);
                } else if (control instanceof Text) {
                    String value = ((Text)control).getText();
                    CompilerFlags.setString((String)flagId, (String)value);
                }
                if (control.getParent().equals(this.fPluginPage)) {
                    this.fBuilders.add("org.eclipse.pde.ManifestBuilder");
                    continue;
                }
                if (control.getParent().equals(this.fSchemaPage)) {
                    this.fBuilders.add("org.eclipse.pde.SchemaBuilder");
                    continue;
                }
                if (!control.getParent().equals(this.fFeaturePage)) continue;
                this.fBuilders.add("org.eclipse.pde.FeatureBuilder");
            }
            CompilerFlags.save();
            if (res == 0) {
                this.doFullBuild();
            }
            this.fChangedControls.clear();
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void doFullBuild() {
        Job buildJob = new Job(PDEPlugin.getResourceString("CompilersPreferencePage.building")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] projects = PDE.getWorkspace().getRoot().getProjects();
                    monitor.beginTask("", projects.length * 2);
                    for (int i = 0; i < projects.length; ++i) {
                        IProject project = projects[i];
                        if (!project.isOpen()) continue;
                        if (project.hasNature("org.eclipse.pde.PluginNature")) {
                            if (CompilersPreferencePage.this.fBuilders.contains("org.eclipse.pde.ManifestBuilder")) {
                                project.build(6, "org.eclipse.pde.ManifestBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.worked(1);
                            }
                            if (CompilersPreferencePage.this.fBuilders.contains("org.eclipse.pde.SchemaBuilder")) {
                                project.build(6, "org.eclipse.pde.SchemaBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                continue;
                            }
                            monitor.worked(1);
                            continue;
                        }
                        if (project.hasNature("org.eclipse.pde.FeatureNature")) {
                            if (!CompilersPreferencePage.this.fBuilders.contains("org.eclipse.pde.FeatureBuilder")) continue;
                            project.build(6, "org.eclipse.pde.FeatureBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            continue;
                        }
                        monitor.worked(2);
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
    }
}

