/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.intro.impl.model.IntroStandbyContentPart;
import org.eclipse.ui.internal.intro.impl.model.IntroURLAction;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;

public class SharedConfigExtensionsManager {
    private IExtensionRegistry registry;
    private Hashtable standbyParts = new Hashtable();
    private Hashtable commands = new Hashtable();

    protected SharedConfigExtensionsManager(IExtensionRegistry registry) {
        this.registry = registry;
    }

    protected void loadSharedConfigExtensions() {
        IConfigurationElement[] configExtensionElements = this.registry.getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        for (int i = 0; i < configExtensionElements.length; ++i) {
            IConfigurationElement element = configExtensionElements[i];
            if (!ModelLoaderUtil.isValidElementName(element, "standbyContentPart") && !ModelLoaderUtil.isValidElementName(element, "action")) continue;
            this.createModelClass(element);
        }
    }

    private void createModelClass(IConfigurationElement element) {
        if (element.getName().equals("standbyContentPart")) {
            IntroStandbyContentPart standbyPartContent = new IntroStandbyContentPart(element);
            if (standbyPartContent.getId() == null) {
                return;
            }
            this.standbyParts.put(standbyPartContent.getId(), standbyPartContent);
        } else {
            IntroURLAction introURLCommand = new IntroURLAction(element);
            if (introURLCommand.getName() == null || introURLCommand.getReplaceValue() == null) {
                return;
            }
            this.commands.put(introURLCommand.getName(), introURLCommand);
        }
    }

    public IntroStandbyContentPart getStandbyPart(String partId) {
        if (partId == null) {
            return null;
        }
        return (IntroStandbyContentPart)this.standbyParts.get(partId);
    }

    public IntroURLAction getCommand(String commandName) {
        if (commandName == null) {
            return null;
        }
        return (IntroURLAction)this.commands.get(commandName);
    }
}

