/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.UnknownElement;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.ui.editor.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntImportNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.editor.model.AntTargetNode;
import org.eclipse.ant.internal.ui.editor.model.AntTaskNode;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorMarkerUpdater;
import org.eclipse.ant.internal.ui.editor.outline.AntModelProject;
import org.eclipse.ant.internal.ui.editor.outline.AntOutlineMessages;
import org.eclipse.ant.internal.ui.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.editor.outline.IProblemRequestor;
import org.eclipse.ant.internal.ui.editor.outline.LocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.editor.outline.XMLProblem;
import org.eclipse.ant.internal.ui.editor.utils.ProjectHelper;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class AntModel {
    private static ClassLoader fgClassLoader;
    private static int fgInstanceCount;
    private XMLCore fCore;
    private IDocument fDocument;
    private IProblemRequestor fProblemRequestor;
    private LocationProvider fLocationProvider;
    private AntProjectNode fProjectNode;
    private AntTargetNode fCurrentTargetNode;
    private AntElementNode fLastNode;
    private AntElementNode fNodeBeingResolved;
    private AntTargetNode fIncrementalTarget = null;
    private boolean fReplaceHasOccurred = false;
    private int fRemoveLengthOfReplace = 0;
    private DirtyRegion fDirtyRegion = null;
    private Stack fStillOpenElements = new Stack();
    private Map fTaskToNode = new HashMap();
    private List fTaskNodes = new ArrayList();
    private Map fEntityNameToPath;
    private final Object fDirtyLock = new Object();
    private boolean fIsDirty = true;
    private IDocumentListener fListener;
    private File fEditedFile = null;
    private AntEditorMarkerUpdater fMarkerUpdater = null;
    private Set fNamesOfOldDefiningNodes;
    private Preferences.IPropertyChangeListener fCorePropertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("classpath_changed") && (Boolean)event.getNewValue() == Boolean.TRUE) {
                AntModel.this.reconcileForPropertyChange(true);
            }
        }
    };
    private Preferences.IPropertyChangeListener fUIPropertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("problem")) {
                AntUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(AntModel.this.fUIPropertyChangeListener);
                AntModel.this.reconcileForPropertyChange(false);
                AntUIPlugin.getDefault().getPluginPreferences().setToDefault("problem");
                AntUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(AntModel.this.fUIPropertyChangeListener);
            } else if (property.equals("content_assist_userDefinedTasks") && ((Boolean)event.getNewValue()).booleanValue()) {
                AntModel.this.reconcileForPropertyChange(false);
            }
        }
    };
    static /* synthetic */ Class class$org$eclipse$ant$internal$ui$editor$outline$AntModel;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskAdapter;

    public AntModel(XMLCore core, IDocument document, IProblemRequestor problemRequestor, LocationProvider locationProvider) {
        this.fCore = core;
        this.fDocument = document;
        this.fProblemRequestor = problemRequestor;
        this.fMarkerUpdater = new AntEditorMarkerUpdater();
        this.fMarkerUpdater.setModel(this);
        this.fLocationProvider = locationProvider;
        AntCorePlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.fCorePropertyChangeListener);
        AntUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.fUIPropertyChangeListener);
        AntDefiningTaskNode.setJavaClassPath();
        ++fgInstanceCount;
    }

    private void reconcileForPropertyChange(boolean classpathChanged) {
        if (classpathChanged) {
            fgClassLoader = null;
            AntDefiningTaskNode.setJavaClassPath();
        }
        this.fIsDirty = true;
        this.reconcile(null);
        this.fCore.notifyDocumentModelListeners(new DocumentModelChangeEvent(this, true));
        this.fMarkerUpdater.updateMarkers();
    }

    public void install() {
        this.fListener = new IDocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentAboutToBeChanged(DocumentEvent event) {
                Object object = AntModel.this.fDirtyLock;
                synchronized (object) {
                    AntModel.this.fIsDirty = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        };
        this.fDocument.addDocumentListener(this.fListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AntModel antModel = this;
        synchronized (antModel) {
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener(this.fListener);
            }
            this.fDocument = null;
            this.fCore = null;
            ProjectHelper.setAntModel(null);
        }
        AntCorePlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.fCorePropertyChangeListener);
        AntUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.fUIPropertyChangeListener);
        if (--fgInstanceCount == 0) {
            fgClassLoader = null;
        }
        if (this.getProjectNode() != null) {
            IntrospectionHelper.getHelper((Project)this.getProjectNode().getProject(), (Class)(class$org$eclipse$ant$internal$ui$editor$outline$AntModel == null ? (class$org$eclipse$ant$internal$ui$editor$outline$AntModel = AntModel.class$("org.eclipse.ant.internal.ui.editor.outline.AntModel")) : class$org$eclipse$ant$internal$ui$editor$outline$AntModel));
            this.getProjectNode().getProject().fireBuildFinished(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(DirtyRegion region) {
        this.fDirtyRegion = region = null;
        Object object = this.fDirtyLock;
        synchronized (object) {
            if (!this.fIsDirty) {
                return;
            }
            if (this.fReplaceHasOccurred && region != null) {
                this.fRemoveLengthOfReplace = region.getLength();
                this.fReplaceHasOccurred = false;
                return;
            }
            this.fIsDirty = false;
        }
        object = this;
        synchronized (object) {
            if (this.fCore == null) {
                return;
            }
            if (this.fDocument == null) {
                this.fProjectNode = null;
            } else {
                this.reset(region);
                this.parseDocument(this.fDocument, region);
                this.fRemoveLengthOfReplace = 0;
                this.fDirtyRegion = null;
                this.reconcileTaskAndTypes();
            }
            this.fCore.notifyDocumentModelListeners(new DocumentModelChangeEvent(this));
        }
    }

    private void reset(DirtyRegion region) {
        this.fCurrentTargetNode = null;
        if (region == null) {
            this.fStillOpenElements = new Stack();
            this.fTaskToNode = new HashMap();
            this.fTaskNodes = new ArrayList();
            this.fNodeBeingResolved = null;
            this.fLastNode = null;
        }
    }

    public AntElementNode[] getRootElements() {
        this.reconcile(null);
        if (this.fProjectNode == null) {
            return new AntElementNode[0];
        }
        return new AntElementNode[]{this.fProjectNode};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDocument(IDocument input, DirtyRegion region) {
        Project project;
        boolean incremental;
        ClassLoader originalClassLoader;
        boolean parsed;
        block17: {
            block16: {
                parsed = true;
                if (input.getLength() == 0) {
                    this.fProjectNode = null;
                    return;
                }
                ClassLoader parsingClassLoader = this.getClassLoader();
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(parsingClassLoader);
                incremental = false;
                project = null;
                try {
                    try {
                        String textToParse = null;
                        ProjectHelper projectHelper = null;
                        if (region == null || this.fProjectNode == null) {
                            if (this.fProjectNode == null || !this.fProjectNode.hasChildren()) {
                                this.fProjectNode = null;
                                project = new AntModelProject();
                                projectHelper = this.prepareForFullParse(project, parsingClassLoader);
                                textToParse = input.get();
                            } else {
                                project = this.fProjectNode.getProject();
                                projectHelper = (ProjectHelper)((Object)project.getReference("ant.projectHelper"));
                                textToParse = this.prepareForFullIncremental(input);
                            }
                        } else {
                            project = this.fProjectNode.getProject();
                            textToParse = this.prepareForIncrementalParse(project, region, input);
                            if (textToParse == null) {
                                parsed = false;
                                Object var12_11 = null;
                                Thread.currentThread().setContextClassLoader(originalClassLoader);
                                if (!parsed) return;
                                if (incremental) {
                                    this.updateAfterIncrementalChange(region, true);
                                }
                                this.resolveBuildfile();
                                this.endReporting();
                                break block16;
                            }
                            incremental = true;
                            projectHelper = (ProjectHelper)((Object)project.getReference("ant.projectHelper"));
                        }
                        this.beginReporting();
                        Hashtable references = project.getReferences();
                        references.remove("ant.parsing.context");
                        ProjectHelper.setAntModel(this);
                        projectHelper.parse(project, textToParse);
                        break block17;
                    }
                    catch (BuildException e) {
                        this.handleBuildException(e, null);
                        Object var12_13 = null;
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        if (!parsed) return;
                        if (incremental) {
                            this.updateAfterIncrementalChange(region, true);
                        }
                        this.resolveBuildfile();
                        this.endReporting();
                        project.fireBuildFinished(null);
                        this.fIncrementalTarget = null;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    if (!parsed) throw throwable;
                    if (incremental) {
                        this.updateAfterIncrementalChange(region, true);
                    }
                    this.resolveBuildfile();
                    this.endReporting();
                    project.fireBuildFinished(null);
                    this.fIncrementalTarget = null;
                    throw throwable;
                }
            }
            project.fireBuildFinished(null);
            this.fIncrementalTarget = null;
            return;
        }
        Object var12_12 = null;
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        if (!parsed) return;
        if (incremental) {
            this.updateAfterIncrementalChange(region, true);
        }
        this.resolveBuildfile();
        this.endReporting();
        project.fireBuildFinished(null);
        this.fIncrementalTarget = null;
    }

    private void updateAfterIncrementalChange(DirtyRegion region, boolean updateProjectLength) {
        if (this.fProjectNode == null) {
            return;
        }
        int editAdjustment = this.determineEditAdjustment(region);
        if (editAdjustment == 0) {
            return;
        }
        if (updateProjectLength) {
            this.fProjectNode.setLength(this.fProjectNode.getLength() + editAdjustment);
        } else {
            this.fProjectNode.setOffset(this.fProjectNode.getOffset() + editAdjustment);
        }
        if ((this.fIncrementalTarget != null || !updateProjectLength) && this.fProjectNode.hasChildren()) {
            List children = this.fProjectNode.getChildNodes();
            int index = children.indexOf(this.fIncrementalTarget) + 1;
            this.updateNodesForIncrementalParse(editAdjustment, children, index);
        }
    }

    private void updateNodesForIncrementalParse(int editAdjustment, List children, int index) {
        for (int i = index; i < children.size(); ++i) {
            AntElementNode node = (AntElementNode)children.get(i);
            node.setOffset(node.getOffset() + editAdjustment);
            if (!node.hasChildren()) continue;
            this.updateNodesForIncrementalParse(editAdjustment, node.getChildNodes(), 0);
        }
    }

    private ProjectHelper prepareForFullParse(Project project, ClassLoader parsingClassLoader) {
        this.initializeProject(project, parsingClassLoader);
        File file = this.getEditedFile();
        String filePath = "";
        if (file != null) {
            filePath = file.getAbsolutePath();
        }
        project.setUserProperty("ant.file", filePath);
        ProjectHelper projectHelper = new ProjectHelper(this);
        projectHelper.setBuildFile(file);
        project.addReference("ant.projectHelper", (Object)projectHelper);
        return projectHelper;
    }

    private String prepareForIncrementalParse(Project project, DirtyRegion region, IDocument input) {
        String textToParse = null;
        AntElementNode node = this.fProjectNode.getNode(region.getOffset());
        if (node == null) {
            if (this.fProjectNode.getLength() > 0) {
                if (region.getOffset() < this.fProjectNode.getOffset()) {
                    this.updateAfterIncrementalChange(region, false);
                }
                return null;
            }
            textToParse = this.prepareForFullIncremental(input);
            return textToParse;
        }
        while (node != null && !(node instanceof AntTargetNode)) {
            node = node.getParentNode();
        }
        if (node == null) {
            if (region.getText() != null && region.getText().trim().length() == 0) {
                return null;
            }
            textToParse = this.prepareForFullIncremental(input);
        } else {
            this.fIncrementalTarget = (AntTargetNode)node;
            if (this.fIncrementalTarget.hasChildren()) {
                Collection nodes = this.fTaskToNode.values();
                nodes.removeAll(this.fIncrementalTarget.getDescendents());
            }
            this.markHierarchy(node, -1);
            StringBuffer temp = this.createIncrementalContents(project);
            this.fIncrementalTarget.reset();
            try {
                int editAdjustment = this.determineEditAdjustment(region) + 1;
                String targetString = input.get(node.getOffset() - 1, node.getLength() + editAdjustment);
                temp.append(targetString);
                temp.append("\n</project>");
                textToParse = temp.toString();
            }
            catch (BadLocationException e) {
                textToParse = input.get();
            }
        }
        return textToParse;
    }

    private String prepareForFullIncremental(IDocument input) {
        String textToParse = input.get();
        this.fProjectNode.reset();
        this.fTaskToNode = new HashMap();
        this.fTaskNodes = new ArrayList();
        return textToParse;
    }

    private StringBuffer createIncrementalContents(Project project) {
        int offset = this.fIncrementalTarget.getOffset();
        int line = this.getLine(offset) - 1;
        StringBuffer temp = new StringBuffer("<project");
        String defltTarget = project.getDefaultTarget();
        if (defltTarget != null) {
            temp.append(" default=\"");
            temp.append(defltTarget);
            temp.append("\"");
        }
        temp.append(">");
        while (line > 0) {
            temp.append("\n");
            --line;
        }
        return temp;
    }

    private int determineEditAdjustment(DirtyRegion region) {
        int editAdjustment = 0;
        editAdjustment = region.getType().equals("__insert") ? (editAdjustment += region.getLength() - this.fRemoveLengthOfReplace) : (editAdjustment -= region.getLength());
        return editAdjustment;
    }

    private void initializeProject(Project project, ClassLoader loader) {
        project.init();
        this.setTasks(project, loader);
        this.setTypes(project, loader);
    }

    private void setTasks(Project project, ClassLoader loader) {
        List tasks = AntCorePlugin.getPlugin().getPreferences().getTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            AntTypeDefinition def = new AntTypeDefinition();
            def.setName(task.getTaskName());
            def.setClassName(task.getClassName());
            def.setClassLoader(loader);
            def.setAdaptToClass(class$org$apache$tools$ant$Task == null ? AntModel.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task);
            def.setAdapterClass(class$org$apache$tools$ant$TaskAdapter == null ? AntModel.class$("org.apache.tools.ant.TaskAdapter") : class$org$apache$tools$ant$TaskAdapter);
            ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
        }
    }

    private void setTypes(Project project, ClassLoader loader) {
        List types = AntCorePlugin.getPlugin().getPreferences().getTypes();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            AntTypeDefinition def = new AntTypeDefinition();
            def.setName(type.getTypeName());
            def.setClassName(type.getClassName());
            def.setClassLoader(loader);
            ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
        }
    }

    private void resolveBuildfile() {
        ArrayList nodeCopy = new ArrayList(this.fTaskNodes.size());
        nodeCopy.addAll(this.fTaskNodes);
        Iterator iter = nodeCopy.iterator();
        while (iter.hasNext()) {
            AntTaskNode node = (AntTaskNode)iter.next();
            this.fNodeBeingResolved = node;
            if (!node.configure(false)) continue;
            this.resolveBuildfile();
        }
        this.fNodeBeingResolved = null;
        this.checkTargets();
    }

    private void checkTargets() {
        if (this.fProjectNode == null) {
            return;
        }
        String defaultTargetName = this.fProjectNode.getProject().getDefaultTarget();
        if (defaultTargetName == null || this.fProjectNode.getProject().getTargets().get(defaultTargetName) == null) {
            String message = defaultTargetName == null ? AntOutlineMessages.getString("AntModel.0") : MessageFormat.format(AntOutlineMessages.getString("AntModel.43"), defaultTargetName);
            IProblem problem = this.createProblem(message, this.fProjectNode.getOffset(), this.fProjectNode.getSelectionLength(), 1);
            this.acceptProblem(problem);
            this.markHierarchy(this.fProjectNode, 1);
        }
        if (!this.fProjectNode.hasChildren()) {
            return;
        }
        List children = this.fProjectNode.getChildNodes();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            String missing;
            AntElementNode node;
            AntElementNode originalNode = node = (AntElementNode)iter.next();
            if (!(node instanceof AntTargetNode) || (missing = ((AntTargetNode)node).checkDependencies()) == null) continue;
            String message = MessageFormat.format(AntOutlineMessages.getString("AntModel.44"), missing);
            AntElementNode importNode = node.getImportNode();
            if (importNode != null) {
                node = importNode;
            }
            IProblem problem = this.createProblem(message, node.getOffset(), node.getSelectionLength(), 1);
            this.acceptProblem(problem);
            this.markHierarchy(originalNode, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleBuildException(BuildException e, AntElementNode node, int severity) {
        try {
            if (node != null) {
                this.markHierarchy(node, severity);
            }
            Location location = e.getLocation();
            int line = 0;
            int originalOffset = 0;
            int nonWhitespaceOffset = 0;
            int length = 0;
            if (location == Location.UNKNOWN_LOCATION && node != null) {
                nonWhitespaceOffset = node.getOffset();
                length = node.getLength();
            } else {
                line = location.getLineNumber();
                if (line == 0) {
                    if (this.getProjectNode() == null) return;
                    length = this.getProjectNode().getSelectionLength();
                    nonWhitespaceOffset = this.getProjectNode().getOffset();
                    if (severity == 1) {
                        this.getProjectNode().setProblemSeverity(-1);
                    }
                } else if (node == null) {
                    nonWhitespaceOffset = originalOffset = this.getOffset(line, 1);
                    try {
                        nonWhitespaceOffset = this.getNonWhitespaceOffset(line, 1);
                    }
                    catch (BadLocationException be) {
                        // empty catch block
                    }
                    length = this.getLastCharColumn(line) - (nonWhitespaceOffset - originalOffset);
                } else {
                    nonWhitespaceOffset = node.getOffset();
                    length = node.getLength();
                }
            }
            this.notifyProblemRequestor((Exception)((Object)e), nonWhitespaceOffset, length, severity);
            return;
        }
        catch (BadLocationException e1) {
            // empty catch block
        }
    }

    public void handleBuildException(BuildException e, AntElementNode node) {
        this.handleBuildException(e, node, 1);
    }

    public File getEditedFile() {
        if (this.fLocationProvider != null && this.fEditedFile == null) {
            this.fEditedFile = this.fLocationProvider.getLocation().toFile();
        }
        return this.fEditedFile;
    }

    private void markHierarchy(AntElementNode openElement, int severity) {
        while (openElement != null) {
            openElement.setProblemSeverity(severity);
            openElement = openElement.getParentNode();
        }
    }

    public LocationProvider getLocationProvider() {
        return this.fLocationProvider;
    }

    public void addTarget(Target newTarget, int line, int column) {
        if (this.fIncrementalTarget != null) {
            this.fCurrentTargetNode = this.fIncrementalTarget;
            this.fCurrentTargetNode.setTarget(newTarget);
            this.fStillOpenElements.push(this.fCurrentTargetNode);
        } else {
            AntTargetNode targetNode = new AntTargetNode(newTarget);
            this.fProjectNode.addChildNode(targetNode);
            this.fCurrentTargetNode = targetNode;
            this.fStillOpenElements.push(targetNode);
            this.computeOffset(targetNode, line, column);
            if (this.fNodeBeingResolved instanceof AntImportNode) {
                targetNode.setImportNode(this.fNodeBeingResolved);
            }
        }
    }

    public void addProject(Project project, int line, int column) {
        if (this.fIncrementalTarget != null) {
            return;
        }
        this.fProjectNode = new AntProjectNode((AntModelProject)project, this);
        this.fStillOpenElements.push(this.fProjectNode);
        this.computeOffset(this.fProjectNode, line, column);
    }

    public void addTask(org.apache.tools.ant.Task newTask, org.apache.tools.ant.Task parentTask, Attributes attributes, int line, int column) {
        AntTaskNode taskNode = null;
        if (parentTask == null) {
            taskNode = this.newTaskNode(newTask, attributes);
            if (this.fCurrentTargetNode == null) {
                this.fProjectNode.addChildNode(taskNode);
            } else {
                this.fCurrentTargetNode.addChildNode(taskNode);
                if (taskNode.isExternal()) {
                    this.fCurrentTargetNode.setExternal(true);
                    this.fCurrentTargetNode.setFilePath(taskNode.getFilePath());
                }
            }
        } else {
            taskNode = this.newNotWellKnownTaskNode(newTask, attributes);
            ((AntTaskNode)this.fTaskToNode.get(parentTask)).addChildNode(taskNode);
        }
        this.fTaskToNode.put(newTask, taskNode);
        this.fStillOpenElements.push(taskNode);
        this.computeOffset(taskNode, line, column);
        if (this.fNodeBeingResolved instanceof AntImportNode) {
            taskNode.setImportNode(this.fNodeBeingResolved);
            int index = this.fTaskNodes.indexOf(this.fNodeBeingResolved) + 1;
            this.fTaskNodes.add(index, taskNode);
        } else {
            this.fTaskNodes.add(taskNode);
        }
    }

    public void addEntity(String entityName, String entityPath) {
        if (this.fEntityNameToPath == null) {
            this.fEntityNameToPath = new HashMap();
        }
        this.fEntityNameToPath.put(entityName, entityPath);
    }

    private AntTaskNode newTaskNode(org.apache.tools.ant.Task newTask, Attributes attributes) {
        String label;
        AntTaskNode newNode = null;
        String taskName = newTask.getTaskName();
        if (AntModel.isPropertySettingTask(taskName)) {
            newNode = new AntPropertyNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("import")) {
            newNode = new AntImportNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("macrodef") || taskName.equalsIgnoreCase("presetdef") || taskName.equalsIgnoreCase("typedef") || taskName.equalsIgnoreCase("taskdef")) {
            String name = attributes.getValue("name");
            newNode = new AntDefiningTaskNode(newTask, name);
        } else if (taskName.equalsIgnoreCase("antcall")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "target"));
        } else if (taskName.equalsIgnoreCase("mkdir")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "dir"));
        } else if (taskName.equalsIgnoreCase("copy")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "destfile"));
        } else if (taskName.equalsIgnoreCase("tar") || taskName.equalsIgnoreCase("jar") || taskName.equalsIgnoreCase("war") || taskName.equalsIgnoreCase("zip")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "destfile"));
        } else if (taskName.equalsIgnoreCase("untar") || taskName.equalsIgnoreCase("unjar") || taskName.equalsIgnoreCase("unwar") || taskName.equalsIgnoreCase("gunzip") || taskName.equalsIgnoreCase("bunzip2") || taskName.equalsIgnoreCase("unzip")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "src"));
        } else if (taskName.equalsIgnoreCase("gzip") || taskName.equalsIgnoreCase("bzip2")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "zipfile"));
        } else if (taskName.equalsIgnoreCase("exec")) {
            label = "exec ";
            String command = attributes.getValue("command");
            if (command != null) {
                label = label + command;
            }
            if ((command = attributes.getValue("executable")) != null) {
                label = label + command;
            }
            newNode = new AntTaskNode(newTask, label);
        } else if (taskName.equalsIgnoreCase("delete")) {
            label = "delete ";
            String file = attributes.getValue("file");
            if (file != null) {
                label = label + file;
            } else {
                file = attributes.getValue("dir");
                if (file != null) {
                    label = label + file;
                }
            }
            newNode = new AntTaskNode(newTask, label);
        } else {
            newNode = taskName.equalsIgnoreCase("import") ? new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "file")) : this.newNotWellKnownTaskNode(newTask, attributes);
        }
        String taskFileName = newTask.getLocation().getFileName();
        boolean external = this.isTaskExternal(taskFileName);
        newNode.setExternal(external);
        if (external) {
            newNode.setFilePath(taskFileName);
        }
        return newNode;
    }

    public static boolean isPropertySettingTask(String taskName) {
        return taskName.equalsIgnoreCase("property") || taskName.equalsIgnoreCase("available") || taskName.equalsIgnoreCase("basename") || taskName.equalsIgnoreCase("condition") || taskName.equalsIgnoreCase("dirname") || taskName.equalsIgnoreCase("loadfile") || taskName.equalsIgnoreCase("pathconvert") || taskName.equalsIgnoreCase("uptodate") || taskName.equalsIgnoreCase("xmlproperty");
    }

    private boolean isTaskExternal(String taskFileName) {
        File taskFile = new File(taskFileName);
        return !taskFile.equals(this.getEditedFile());
    }

    private AntTaskNode newNotWellKnownTaskNode(org.apache.tools.ant.Task newTask, Attributes attributes) {
        AntTaskNode newNode = new AntTaskNode(newTask);
        String id = attributes.getValue("id");
        if (id != null) {
            newNode.setId(id);
        }
        return newNode;
    }

    private String generateLabel(String taskName, Attributes attributes, String attributeName) {
        StringBuffer label = new StringBuffer(taskName);
        String srcFile = attributes.getValue(attributeName);
        if (srcFile != null) {
            label.append(' ');
            label.append(srcFile);
        }
        return label.toString();
    }

    private void computeLength(AntElementNode element, int line, int column) {
        if (element.isExternal()) {
            element.setExternalInfo(line, column);
            return;
        }
        try {
            int offset;
            if (column <= 0) {
                column = this.getLastCharColumn(line);
                String lineText = this.fDocument.get(this.fDocument.getLineOffset(line - 1), column);
                StringBuffer searchString = new StringBuffer("</");
                searchString.append(element.getName());
                searchString.append('>');
                int index = lineText.indexOf(searchString.toString());
                index = index == -1 ? ((index = lineText.indexOf("/>")) == -1 ? column : (index += 3)) : index + searchString.length() + 1;
                offset = this.getOffset(line, index);
            } else {
                offset = this.getOffset(line, column);
            }
            int length = offset - element.getOffset();
            element.setLength(length);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private void computeOffset(AntElementNode element, int line, int column) {
        if (element.isExternal()) {
            return;
        }
        try {
            int offset;
            String prefix = "<";
            if (column <= 0) {
                offset = this.getOffset(line, 0);
                int lastCharColumn = this.getLastCharColumn(line);
                offset = this.computeOffsetUsingPrefix(element, line, offset, prefix, lastCharColumn);
            } else {
                offset = this.getOffset(line, column);
                offset = this.computeOffsetUsingPrefix(element, line, offset, prefix, column);
            }
            element.setOffset(offset + 1);
            element.setSelectionLength(element.getName().length());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private int computeOffsetUsingPrefix(AntElementNode element, int line, int offset, String prefix, int column) throws BadLocationException {
        String lineText = this.fDocument.get(this.fDocument.getLineOffset(line - 1), column);
        int lastIndex = lineText.indexOf(prefix + element.getName());
        if (lastIndex <= -1) {
            return this.computeOffsetUsingPrefix(element, line - 1, offset, prefix, this.getLastCharColumn(line - 1));
        }
        offset = this.getOffset(line, lastIndex + 1);
        return offset;
    }

    public int getOffset(int line, int column) throws BadLocationException {
        return this.fDocument.getLineOffset(line - 1) + column - 1;
    }

    private int getNonWhitespaceOffset(int line, int column) throws BadLocationException {
        int offset = this.fDocument.getLineOffset(line - 1) + column - 1;
        while (Character.isWhitespace(this.fDocument.getChar(offset))) {
            ++offset;
        }
        return offset;
    }

    private int getLine(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException be) {
            return -1;
        }
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.fDocument.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.fDocument.getLineLength(line - 1) - lineDelimiterLength;
    }

    public void setCurrentElementLength(int lineNumber, int column) {
        this.fLastNode = (AntElementNode)this.fStillOpenElements.pop();
        if (this.fLastNode == this.fCurrentTargetNode) {
            this.fCurrentTargetNode = null;
        }
        this.computeLength(this.fLastNode, lineNumber, column);
    }

    public void acceptProblem(IProblem problem) {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.acceptProblem(problem);
            this.fMarkerUpdater.acceptProblem(problem);
        }
    }

    protected IFile getFile() {
        IPath location = this.fLocationProvider.getLocation();
        if (location == null) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(location);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    private void beginReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.beginReporting();
            this.fMarkerUpdater.beginReporting();
        }
    }

    private void endReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.endReporting();
        }
    }

    private IProblem createProblem(Exception exception, int offset, int length, int severity) {
        return this.createProblem(exception.getMessage(), offset, length, severity);
    }

    private IProblem createProblem(String message, int offset, int length, int severity) {
        return new XMLProblem(message, severity, offset, length, this.getLine(offset));
    }

    protected void notifyProblemRequestor(Exception exception, AntElementNode element, int severity) {
        AntElementNode importNode = element.getImportNode();
        if (importNode != null) {
            element = importNode;
        }
        IProblem problem = this.createProblem(exception, element.getOffset(), element.getLength(), severity);
        this.acceptProblem(problem);
        element.associatedProblem(problem);
    }

    protected void notifyProblemRequestor(Exception exception, int offset, int length, int severity) {
        if (this.fProblemRequestor != null) {
            IProblem problem = this.createProblem(exception, offset, length, severity);
            this.acceptProblem(problem);
        }
    }

    public void warning(Exception exception) {
        this.notifyProblemRequestor(exception, (AntElementNode)this.fStillOpenElements.pop(), 0);
    }

    public void error(Exception exception) {
        this.handleError(exception, 1);
    }

    public void errorFromElementText(Exception exception, int start, int count) {
        AntElementNode node = this.fLastNode;
        if (node == null && !this.fStillOpenElements.empty()) {
            node = (AntElementNode)this.fStillOpenElements.peek();
        }
        if (node == null) {
            return;
        }
        this.computeEndLocationForErrorNode(node, start, count);
        this.notifyProblemRequestor(exception, start, count, 1);
        this.markHierarchy(this.fLastNode, 1);
    }

    public void errorFromElement(Exception exception, AntElementNode node, int lineNumber, int column) {
        if (node == null) {
            node = !this.fStillOpenElements.empty() ? (AntElementNode)this.fStillOpenElements.peek() : this.fLastNode;
        }
        this.computeEndLocationForErrorNode(node, lineNumber, column);
        this.notifyProblemRequestor(exception, node, 1);
        this.markHierarchy(node, 1);
    }

    private AntElementNode createProblemElement(SAXParseException exception) {
        int lineNumber = exception.getLineNumber();
        StringBuffer message = new StringBuffer(exception.getMessage());
        if (lineNumber != -1) {
            message.append(AntOutlineMessages.getString("AntModel.1") + lineNumber);
        }
        AntElementNode errorNode = new AntElementNode(message.toString());
        errorNode.setFilePath(exception.getSystemId());
        errorNode.setProblemSeverity(1);
        this.computeErrorLocation(errorNode, exception);
        return errorNode;
    }

    private void computeErrorLocation(AntElementNode element, SAXParseException exception) {
        if (element.isExternal()) {
            return;
        }
        int line = exception.getLineNumber();
        int startColumn = exception.getColumnNumber();
        this.computeEndLocationForErrorNode(element, line, startColumn);
    }

    private void computeEndLocationForErrorNode(AntElementNode element, int line, int startColumn) {
        try {
            int endColumn;
            if (line <= 0) {
                line = 1;
            }
            if (startColumn <= 0) {
                startColumn = element.getOffset() > -1 ? element.getOffset() + 1 : 1;
                endColumn = this.getLastCharColumn(line) + 1;
            } else {
                if (startColumn > 1) {
                    --startColumn;
                }
                endColumn = startColumn;
                if (startColumn <= this.getLastCharColumn(line)) {
                    ++endColumn;
                }
            }
            int correction = 0;
            if (element.getOffset() == -1) {
                int originalOffset;
                int nonWhitespaceOffset = originalOffset = this.getOffset(line, startColumn);
                try {
                    nonWhitespaceOffset = this.getNonWhitespaceOffset(line, startColumn);
                }
                catch (BadLocationException be) {
                    // empty catch block
                }
                element.setOffset(nonWhitespaceOffset);
                correction = nonWhitespaceOffset - originalOffset;
            }
            if (endColumn - startColumn == 0) {
                int offset = this.getOffset(line, startColumn);
                element.setLength(offset - element.getOffset() - correction);
            } else {
                element.setLength(endColumn - startColumn - correction);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private void handleError(Exception exception, int severity) {
        AntElementNode node = null;
        if (this.fStillOpenElements.isEmpty()) {
            if (exception instanceof SAXParseException) {
                node = this.createProblemElement((SAXParseException)exception);
            }
        } else {
            node = (AntElementNode)this.fStillOpenElements.peek();
        }
        if (node == null) {
            return;
        }
        this.markHierarchy(node, severity);
        if (exception instanceof SAXParseException) {
            SAXParseException parseException = (SAXParseException)exception;
            if (node.getOffset() == -1) {
                this.computeEndLocationForErrorNode(node, parseException.getLineNumber() - 1, parseException.getColumnNumber());
            } else {
                int lineNumber = parseException.getLineNumber();
                int columnNumber = parseException.getColumnNumber();
                if (columnNumber == -1) {
                    columnNumber = 1;
                }
                try {
                    AntElementNode childNode = node.getNode(this.getNonWhitespaceOffset(lineNumber, columnNumber) + 1);
                    if (childNode != null && childNode != node) {
                        node = childNode;
                        node.setProblemSeverity(severity);
                    } else {
                        node = this.createProblemElement(parseException);
                    }
                }
                catch (BadLocationException be) {
                    node = this.createProblemElement(parseException);
                }
            }
        }
        this.notifyProblemRequestor(exception, node, severity);
        if (node != null) {
            while (node.getParentNode() != null) {
                AntElementNode parentNode = node.getParentNode();
                if (parentNode.getLength() == -1) {
                    parentNode.setLength(node.getOffset() - parentNode.getOffset() + node.getLength());
                }
                node = parentNode;
            }
        }
        if (this.fIncrementalTarget != null) {
            int editAdjustment = this.determineEditAdjustment(this.fDirtyRegion);
            this.fIncrementalTarget.setLength(this.fIncrementalTarget.getLength() + editAdjustment);
            AntElementNode startingNode = null;
            while (this.fStillOpenElements.peek() != this.fIncrementalTarget) {
                startingNode = (AntElementNode)this.fStillOpenElements.pop();
                if (startingNode.getLength() <= -1) continue;
                startingNode.setLength(startingNode.getLength() + editAdjustment);
            }
            this.fStillOpenElements.pop();
            if (startingNode != null && this.fIncrementalTarget.hasChildren()) {
                List children = this.fIncrementalTarget.getChildNodes();
                int index = children.indexOf(startingNode);
                this.updateNodesForIncrementalParse(editAdjustment, children, index);
            }
        }
    }

    public void fatalError(Exception exception) {
        this.handleError(exception, 2);
    }

    public AntElementNode getOpenElement() {
        if (this.fStillOpenElements.isEmpty()) {
            return null;
        }
        return (AntElementNode)this.fStillOpenElements.peek();
    }

    public String getEntityPath(String entityName) {
        if (this.fEntityNameToPath != null) {
            return (String)this.fEntityNameToPath.get(entityName);
        }
        return null;
    }

    public String getEntityName(String path) {
        if (this.fEntityNameToPath != null) {
            Iterator itr = this.fEntityNameToPath.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                String entityPath = (String)this.fEntityNameToPath.get(name);
                if (!entityPath.equals(path)) continue;
                return name;
            }
        }
        return null;
    }

    public String getPropertyValue(String propertyName) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        return projectNode.getProject().getProperty(propertyName);
    }

    public Object getReferenceObject(String refId) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        try {
            Project project = projectNode.getProject();
            Object ref = project.getReference(refId);
            return ref;
        }
        catch (BuildException be) {
            this.handleBuildException(be, null);
            return null;
        }
    }

    public AntElementNode getReferenceNode(String text) {
        Object reference = this.getReferenceObject(text);
        if (reference == null) {
            return null;
        }
        Set nodes = this.fTaskToNode.keySet();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            UnknownElement element;
            Object original = iter.next();
            Object object = original;
            if (object instanceof UnknownElement && (object = (element = (UnknownElement)object).getRealThing()) == null || object != reference) continue;
            return (AntElementNode)this.fTaskToNode.get(original);
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        if (fgClassLoader == null) {
            fgClassLoader = AntCorePlugin.getPlugin().getNewClassLoader(true);
        }
        return fgClassLoader;
    }

    public String getTargetDescription(String targetRename) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        Project project = projectNode.getProject();
        Hashtable targets = project.getTargets();
        Target target = (Target)targets.get(targetRename);
        if (target != null) {
            return target.getDescription();
        }
        return null;
    }

    public AntProjectNode getProjectNode(boolean doReconcile) {
        if (doReconcile) {
            this.reconcile(null);
        }
        return this.fProjectNode;
    }

    public AntProjectNode getProjectNode() {
        return this.getProjectNode(true);
    }

    public void setReplaceHasOccurred() {
        this.fReplaceHasOccurred = true;
    }

    public void updateMarkers() {
        this.reconcile(null);
        this.fMarkerUpdater.updateMarkers();
    }

    public AntElementNode getNode(int offset, boolean waitForReconcile) {
        if (this.getProjectNode(waitForReconcile) != null) {
            return this.getProjectNode(waitForReconcile).getNode(offset);
        }
        return null;
    }

    public void updateForInitialReconcile() {
        this.fMarkerUpdater.updateMarkers();
    }

    public void setNamesOfOldDefiningNodes(Set set) {
        this.fNamesOfOldDefiningNodes = set;
    }

    private void reconcileTaskAndTypes() {
        if (this.fNamesOfOldDefiningNodes == null) {
            return;
        }
        Iterator iter = this.fNamesOfOldDefiningNodes.iterator();
        while (iter.hasNext()) {
            String nodeLabel = (String)iter.next();
            if (this.fProjectNode.getDefininingTaskNode(nodeLabel) != null) continue;
            ComponentHelper helper = ComponentHelper.getComponentHelper((Project)this.fProjectNode.getProject());
            helper.getAntTypeTable().remove(nodeLabel);
            iter.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fgInstanceCount = 0;
    }
}

