/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.GoToAddressDialog;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class GoToAddressAction
extends Action {
    private ITableMemoryViewTab fViewTab;
    private static final String PREFIX = "GoToAddressAction.";
    private static final String TITLE = "GoToAddressAction.title";
    private static final String GO_TO_ADDRESS_FAILED = "GoToAddressAction.Go_to_address_failed";
    private static final String ADDRESS_IS_INVALID = "GoToAddressAction.Address_is_invalid";
    private static final String TOOLTIP = "GoToAddressAction.tooltip";

    public GoToAddressAction(ITableMemoryViewTab viewTab) {
        super(DebugUIMessages.getString(TITLE));
        this.fViewTab = viewTab;
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        WorkbenchHelp.setHelp((IAction)this, (String)(IDebugUIConstants.PLUGIN_ID + ".GoToAddressAction_context"));
    }

    public void run() {
        try {
            Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            GoToAddressDialog dialog = new GoToAddressDialog(shell);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 1) {
                return;
            }
            String expression = dialog.getExpression();
            expression = expression.toUpperCase();
            if ((expression = expression.trim()).startsWith("0X")) {
                expression = expression.substring(2);
            }
            BigInteger address = new BigInteger(expression, 16);
            this.fViewTab.goToAddress(address);
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.getString(GO_TO_ADDRESS_FAILED), DebugUIMessages.getString(GO_TO_ADDRESS_FAILED), (Exception)((Object)e));
        }
        catch (NumberFormatException e1) {
            MemoryViewUtil.openError(DebugUIMessages.getString(GO_TO_ADDRESS_FAILED), DebugUIMessages.getString(ADDRESS_IS_INVALID), null);
        }
    }
}

