/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;

public class RemoteModule
extends RemoteFolder {
    private String label;
    private ICVSRemoteResource[] referencedModules;
    private Command.LocalOption[] localOptions;
    private boolean expandable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteModule[] getRemoteModules(ICVSRepositoryLocation repository, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(Policy.bind("RemoteModule.getRemoteModules"), 100);
        try {
            RemoteModule[] modules;
            Session s = new Session(repository, (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)ResourcesPlugin.getWorkspace().getRoot()), false);
            s.open(Policy.subMonitorFor(monitor, 10), false);
            try {
                modules = Command.CHECKOUT.getRemoteModules(s, tag, Policy.subMonitorFor(monitor, 90));
            }
            finally {
                s.close();
            }
            RemoteModule[] remoteModuleArray = modules;
            return remoteModuleArray;
        }
        finally {
            monitor.done();
        }
    }

    public static RemoteModule[] createRemoteModules(String[] moduleDefinitionStrings, ICVSRepositoryLocation repository, CVSTag tag) {
        ArrayList<RemoteFolder> referencedFolders;
        String moduleName;
        HashMap<String, RemoteModule> modules = new HashMap<String, RemoteModule>();
        HashMap<String, String[]> referencedModulesTable = new HashMap<String, String[]>();
        HashMap<String, String[]> moduleAliases = new HashMap<String, String[]>();
        ArrayList acceptableModules = new ArrayList();
        for (int i = 0; i < moduleDefinitionStrings.length; ++i) {
            String next;
            ArrayList<Command.LocalOption> localOptionsList;
            StringTokenizer tokenizer = new StringTokenizer(moduleDefinitionStrings[i]);
            String moduleName2 = tokenizer.nextToken();
            try {
                localOptionsList = new ArrayList<Command.LocalOption>();
                next = tokenizer.nextToken();
                while (next.charAt(0) == '-') {
                    switch (next.charAt(1)) {
                        case 'a': {
                            localOptionsList.add(Checkout.ALIAS);
                            break;
                        }
                        case 'l': {
                            localOptionsList.add(Checkout.DO_NOT_RECURSE);
                            break;
                        }
                        case 'd': {
                            localOptionsList.add(Checkout.makeDirectoryNameOption(tokenizer.nextToken()));
                            break;
                        }
                        case 'e': 
                        case 'i': 
                        case 'o': 
                        case 't': 
                        case 'u': {
                            tokenizer.nextToken();
                            break;
                        }
                        case 's': {
                            localOptionsList.add(Checkout.makeStatusOption(tokenizer.nextToken()));
                            break;
                        }
                    }
                    next = tokenizer.nextToken();
                }
            }
            catch (NoSuchElementException e) {
                CVSProviderPlugin.log(2, Policy.bind("RemoteModule.invalidDefinition", moduleDefinitionStrings[i], repository.getLocation()), null);
                continue;
            }
            Command.Option[] localOptions = localOptionsList.toArray(new Command.LocalOption[localOptionsList.size()]);
            if (Checkout.ALIAS.isElementOf(localOptions)) {
                if (localOptions.length > 1) {
                    // empty if block
                }
                ArrayList<String> expansions = new ArrayList<String>(10);
                expansions.add(next);
                while (tokenizer.hasMoreTokens()) {
                    expansions.add(tokenizer.nextToken());
                }
                moduleAliases.put(moduleName2, expansions.toArray(new String[expansions.size()]));
                modules.put(moduleName2, new RemoteModule(moduleName2, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
                continue;
            }
            if (next.charAt(0) != '&') {
                String directory = next;
                ArrayList<String> files = new ArrayList<String>();
                while (tokenizer.hasMoreTokens() && next.charAt(0) != '&') {
                    next = tokenizer.nextToken();
                    if (next.charAt(0) == '&') continue;
                    files.add(next);
                }
                RemoteModule remoteModule = new RemoteModule(moduleName2, null, repository, directory, (Command.LocalOption[])localOptions, tag, !files.isEmpty());
                modules.put(moduleName2, remoteModule);
                if (!files.isEmpty()) {
                    ICVSRemoteResource[] children = new ICVSRemoteResource[files.size()];
                    for (int j = 0; j < children.length; ++j) {
                        children[j] = new RemoteFile(remoteModule, 0, (String)files.get(j), null, null, tag);
                        remoteModule.setChildren(children);
                    }
                }
            } else {
                modules.put(moduleName2, new RemoteModule(moduleName2, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
            }
            if (next.charAt(0) != '&') continue;
            ArrayList<String> children = new ArrayList<String>(10);
            children.add(next);
            while (tokenizer.hasMoreTokens()) {
                children.add(tokenizer.nextToken());
            }
            referencedModulesTable.put(moduleName2, children.toArray(new String[children.size()]));
        }
        Iterator iter = moduleAliases.keySet().iterator();
        while (iter.hasNext()) {
            moduleName = (String)iter.next();
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            String[] expansion = (String[])moduleAliases.get(moduleName);
            referencedFolders = new ArrayList<RemoteFolder>();
            boolean expandable = true;
            for (int i = 0; i < expansion.length; ++i) {
                if (expansion[i].charAt(0) == '!') {
                    expandable = false;
                    continue;
                }
                Path path = new Path(expansion[i]);
                if (path.segmentCount() > 1) {
                    expandable = false;
                    continue;
                }
                RemoteModule child = (RemoteModule)modules.get(expansion[i]);
                if (child == null) {
                    referencedFolders.add(new RemoteFolder(null, repository, path.toString(), tag));
                    continue;
                }
                if (child.isAlias()) {
                    expandable = false;
                    continue;
                }
                referencedFolders.add(child);
            }
            if (expandable) {
                module.setChildren(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        iter = modules.keySet().iterator();
        while (iter.hasNext()) {
            moduleName = (String)iter.next();
            String[] children = (String[])referencedModulesTable.get(moduleName);
            if (children == null) continue;
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            referencedFolders = new ArrayList();
            boolean expandable = true;
            for (int i = 0; i < children.length; ++i) {
                RemoteModule child = (RemoteModule)modules.get(children[i].substring(1));
                if (child == null) {
                    expandable = false;
                    continue;
                }
                if (child.isAlias()) {
                    expandable = false;
                    continue;
                }
                if (Command.findOption(child.getLocalOptions(), "-d") != null) {
                    expandable = false;
                    continue;
                }
                referencedFolders.add(child);
            }
            if (expandable) {
                module.setReferencedModules(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        return modules.values().toArray(new RemoteModule[modules.size()]);
    }

    public RemoteModule(String label, RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, Command.LocalOption[] localOptions, CVSTag tag, boolean isStatic) {
        super(parent, label, repository, repositoryRelativePath == null ? "CVSROOT/Emptydir" : repositoryRelativePath, tag, isStatic);
        this.localOptions = localOptions;
        this.label = label;
        this.expandable = true;
    }

    public Command.LocalOption[] getLocalOptions() {
        return this.localOptions;
    }

    public ICVSRemoteResource[] getMembers(CVSTag tagName, IProgressMonitor monitor) throws CVSException {
        ICVSRemoteResource[] allChildren;
        if (!this.expandable) {
            return new ICVSRemoteResource[0];
        }
        ICVSRemoteResource[] physicalChildren = this.folderInfo.getIsStatic() ? this.getChildren() : super.getMembers(tagName, monitor);
        if (this.referencedModules != null && this.referencedModules.length > 0) {
            if (physicalChildren == null) {
                allChildren = this.referencedModules;
            } else {
                int i;
                allChildren = new ICVSRemoteResource[physicalChildren.length + this.referencedModules.length];
                for (i = 0; i < physicalChildren.length; ++i) {
                    allChildren[i] = physicalChildren[i];
                }
                for (i = 0; i < this.referencedModules.length; ++i) {
                    allChildren[i + physicalChildren.length] = this.referencedModules[i];
                }
            }
        } else {
            allChildren = physicalChildren != null ? physicalChildren : new ICVSRemoteResource[]{};
        }
        return allChildren;
    }

    private void setReferencedModules(ICVSRemoteResource[] referencedModules) {
        this.referencedModules = referencedModules;
    }

    public boolean isAlias() {
        return Checkout.ALIAS.isElementOf(this.localOptions);
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    private void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tagName) {
        ICVSRemoteResource[] children;
        RemoteModule r = new RemoteModule(this.label, (RemoteFolder)parent, this.getRepository(), this.folderInfo.getRepository(), this.localOptions, tagName, this.folderInfo.getIsStatic());
        r.setExpandable(this.expandable);
        if (this.folderInfo.getIsStatic() && (children = this.getChildren()) != null) {
            ArrayList<ICVSRemoteResource> taggedChildren = new ArrayList<ICVSRemoteResource>(children.length);
            for (int i = 0; i < children.length; ++i) {
                ICVSRemoteResource resource = children[i];
                taggedChildren.add(((RemoteResource)resource).forTag(r, tagName));
            }
            r.setChildren(taggedChildren.toArray(new ICVSRemoteResource[taggedChildren.size()]));
        }
        if (this.referencedModules != null) {
            ArrayList<ICVSRemoteResource> taggedModules = new ArrayList<ICVSRemoteResource>(this.referencedModules.length);
            for (int i = 0; i < this.referencedModules.length; ++i) {
                RemoteModule module = (RemoteModule)this.referencedModules[i];
                taggedModules.add(module.forTag(r, tagName));
            }
            r.setReferencedModules(taggedModules.toArray(new ICVSRemoteResource[taggedModules.size()]));
        }
        return r;
    }

    public boolean isDefinedModule() {
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RemoteModule) {
            RemoteModule module = (RemoteModule)arg0;
            return this.getName().equals(module.getName()) && super.equals(module);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() | this.getName().hashCode();
    }

    public ICVSResource getChild(String path) throws CVSException {
        if (path.equals(".") || path.length() == 0) {
            return this;
        }
        if (this.referencedModules != null && path.indexOf("/") == -1) {
            for (int i = 0; i < this.referencedModules.length; ++i) {
                if (!this.referencedModules[i].getName().equals(path)) continue;
                return this.referencedModules[i];
            }
        }
        return super.getChild(path);
    }
}

