/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class ExtConnection
implements IServerConnection {
    private static final int DEFAULT_PORT = 9999;
    private ICVSRepositoryLocation location;
    private String password;
    InputStream inputStream;
    OutputStream outputStream;
    Process process;

    protected ExtConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object v1;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            Object var2_1 = null;
            this.inputStream = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var2_2 = null;
            this.inputStream = null;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var4_6 = v0;
            this.outputStream = null;
            if (this.process != null) {
                this.process.destroy();
            }
            throw throwable;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var4_5 = v1;
        this.outputStream = null;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open(IProgressMonitor monitor) throws IOException {
        String[] command = ((CVSRepositoryLocation)this.location).getExtCommand(this.password);
        boolean connected = false;
        try {
            this.process = Util.createProcess(command, monitor);
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream(this.process.getInputStream(), 8192, 1000L, -1L), this.location.getTimeout(), monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream(this.process.getOutputStream(), 8192, 1000L, 1000L), this.location.getTimeout(), monitor);
            DiscardInputThread thread = new DiscardInputThread(this.process.getErrorStream());
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connected) throw throwable;
            this.close();
            throw throwable;
        }
    }

    private static class DiscardInputThread
    extends Thread {
        private InputStream in;

        public DiscardInputThread(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    while (this.in.read() != -1) {
                    }
                }
                finally {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

