/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.wizards.datatransfer.SelectFilesOperation;

public class PopulateRootOperation
extends SelectFilesOperation {
    public PopulateRootOperation(Object rootObject, IImportStructureProvider structureProvider) {
        super(rootObject, structureProvider);
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject) throws InterruptedException {
        return this.createElement(parent, fileSystemObject, 2);
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject, int depth) throws InterruptedException {
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        boolean isContainer = this.provider.isFolder(fileSystemObject);
        String elementLabel = parent == null ? this.provider.getFullPath(fileSystemObject) : this.provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, parent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        if (isContainer && depth > 0) {
            ArrayList children = this.provider.getChildren(fileSystemObject);
            if (children == null) {
                children = new ArrayList(1);
            }
            Iterator childrenEnum = children.iterator();
            while (childrenEnum.hasNext()) {
                this.createElement(result, childrenEnum.next(), depth - 1);
            }
            result.setPopulated();
        }
        return result;
    }
}

