/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ActionSetRegistryReader
extends RegistryReader {
    private static final String TAG_SET = "actionSet";
    private ActionSetRegistry registry;

    public ActionSetRegistryReader() {
    }

    public ActionSetRegistryReader(ActionSetRegistry registry) {
        this.registry = registry;
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_SET)) {
            try {
                ActionSetDescriptor desc = new ActionSetDescriptor(element);
                this.registry.addActionSet(desc);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to create action set descriptor.", e.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readRegistry(IExtensionRegistry in, ActionSetRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui", "actionSets");
        out.mapActionSetsToCategories();
    }
}

